/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.InputDataConfig;
import software.amazon.awssdk.services.healthlake.model.JobProgressReport;
import software.amazon.awssdk.services.healthlake.model.JobStatus;
import software.amazon.awssdk.services.healthlake.model.OutputDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportJobProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(ImportJobProperties.getter(ImportJobProperties::jobId)).setter(ImportJobProperties.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(ImportJobProperties.getter(ImportJobProperties::jobName)).setter(ImportJobProperties.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(ImportJobProperties.getter(ImportJobProperties::jobStatusAsString)).setter(ImportJobProperties.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTime").getter(ImportJobProperties.getter(ImportJobProperties::submitTime)).setter(ImportJobProperties.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ImportJobProperties.getter(ImportJobProperties::endTime)).setter(ImportJobProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreId").getter(ImportJobProperties.getter(ImportJobProperties::datastoreId)).setter(ImportJobProperties.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(ImportJobProperties.getter(ImportJobProperties::inputDataConfig)).setter(ImportJobProperties.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> JOB_OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobOutputDataConfig").getter(ImportJobProperties.getter(ImportJobProperties::jobOutputDataConfig)).setter(ImportJobProperties.setter(Builder::jobOutputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobOutputDataConfig").build()}).build();
    private static final SdkField<JobProgressReport> JOB_PROGRESS_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobProgressReport").getter(ImportJobProperties.getter(ImportJobProperties::jobProgressReport)).setter(ImportJobProperties.setter(Builder::jobProgressReport)).constructor(JobProgressReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobProgressReport").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(ImportJobProperties.getter(ImportJobProperties::dataAccessRoleArn)).setter(ImportJobProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ImportJobProperties.getter(ImportJobProperties::message)).setter(ImportJobProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD, JOB_STATUS_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, DATASTORE_ID_FIELD, INPUT_DATA_CONFIG_FIELD, JOB_OUTPUT_DATA_CONFIG_FIELD, JOB_PROGRESS_REPORT_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportJobProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobName;
    private final String jobStatus;
    private final Instant submitTime;
    private final Instant endTime;
    private final String datastoreId;
    private final InputDataConfig inputDataConfig;
    private final OutputDataConfig jobOutputDataConfig;
    private final JobProgressReport jobProgressReport;
    private final String dataAccessRoleArn;
    private final String message;

    private ImportJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.datastoreId = builder.datastoreId;
        this.inputDataConfig = builder.inputDataConfig;
        this.jobOutputDataConfig = builder.jobOutputDataConfig;
        this.jobProgressReport = builder.jobProgressReport;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.message = builder.message;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final OutputDataConfig jobOutputDataConfig() {
        return this.jobOutputDataConfig;
    }

    public final JobProgressReport jobProgressReport() {
        return this.jobProgressReport;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobProgressReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobProperties)) {
            return false;
        }
        ImportJobProperties other = (ImportJobProperties)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.jobOutputDataConfig(), other.jobOutputDataConfig()) && Objects.equals(this.jobProgressReport(), other.jobProgressReport()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"ImportJobProperties").add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("SubmitTime", (Object)this.submitTime()).add("EndTime", (Object)this.endTime()).add("DatastoreId", (Object)this.datastoreId()).add("InputDataConfig", (Object)this.inputDataConfig()).add("JobOutputDataConfig", (Object)this.jobOutputDataConfig()).add("JobProgressReport", (Object)this.jobProgressReport()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "DatastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "JobOutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.jobOutputDataConfig()));
            }
            case "JobProgressReport": {
                return Optional.ofNullable(clazz.cast(this.jobProgressReport()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("SubmitTime", SUBMIT_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("DatastoreId", DATASTORE_ID_FIELD);
        map.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
        map.put("JobOutputDataConfig", JOB_OUTPUT_DATA_CONFIG_FIELD);
        map.put("JobProgressReport", JOB_PROGRESS_REPORT_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportJobProperties, T> g) {
        return obj -> g.apply((ImportJobProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobName;
        private String jobStatus;
        private Instant submitTime;
        private Instant endTime;
        private String datastoreId;
        private InputDataConfig inputDataConfig;
        private OutputDataConfig jobOutputDataConfig;
        private JobProgressReport jobProgressReport;
        private String dataAccessRoleArn;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobProperties model) {
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.submitTime(model.submitTime);
            this.endTime(model.endTime);
            this.datastoreId(model.datastoreId);
            this.inputDataConfig(model.inputDataConfig);
            this.jobOutputDataConfig(model.jobOutputDataConfig);
            this.jobProgressReport(model.jobProgressReport);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.message(model.message);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getJobOutputDataConfig() {
            return this.jobOutputDataConfig != null ? this.jobOutputDataConfig.toBuilder() : null;
        }

        public final void setJobOutputDataConfig(OutputDataConfig.BuilderImpl jobOutputDataConfig) {
            this.jobOutputDataConfig = jobOutputDataConfig != null ? jobOutputDataConfig.build() : null;
        }

        @Override
        public final Builder jobOutputDataConfig(OutputDataConfig jobOutputDataConfig) {
            this.jobOutputDataConfig = jobOutputDataConfig;
            return this;
        }

        public final JobProgressReport.Builder getJobProgressReport() {
            return this.jobProgressReport != null ? this.jobProgressReport.toBuilder() : null;
        }

        public final void setJobProgressReport(JobProgressReport.BuilderImpl jobProgressReport) {
            this.jobProgressReport = jobProgressReport != null ? jobProgressReport.build() : null;
        }

        @Override
        public final Builder jobProgressReport(JobProgressReport jobProgressReport) {
            this.jobProgressReport = jobProgressReport;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public ImportJobProperties build() {
            return new ImportJobProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportJobProperties> {
        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder submitTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder datastoreId(String var1);

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder jobOutputDataConfig(OutputDataConfig var1);

        default public Builder jobOutputDataConfig(Consumer<OutputDataConfig.Builder> jobOutputDataConfig) {
            return this.jobOutputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(jobOutputDataConfig)).build());
        }

        public Builder jobProgressReport(JobProgressReport var1);

        default public Builder jobProgressReport(Consumer<JobProgressReport.Builder> jobProgressReport) {
            return this.jobProgressReport((JobProgressReport)((JobProgressReport.Builder)JobProgressReport.builder().applyMutation(jobProgressReport)).build());
        }

        public Builder dataAccessRoleArn(String var1);

        public Builder message(String var1);
    }
}

