/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.healthlake.model.ExportJobProperties;
import software.amazon.awssdk.services.healthlake.model.ExportJobPropertiesListCopier;
import software.amazon.awssdk.services.healthlake.model.HealthLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFhirExportJobsResponse
extends HealthLakeResponse
implements ToCopyableBuilder<Builder, ListFhirExportJobsResponse> {
    private static final SdkField<List<ExportJobProperties>> EXPORT_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportJobPropertiesList").getter(ListFhirExportJobsResponse.getter(ListFhirExportJobsResponse::exportJobPropertiesList)).setter(ListFhirExportJobsResponse.setter(Builder::exportJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFhirExportJobsResponse.getter(ListFhirExportJobsResponse::nextToken)).setter(ListFhirExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFhirExportJobsResponse.memberNameToFieldInitializer();
    private final List<ExportJobProperties> exportJobPropertiesList;
    private final String nextToken;

    private ListFhirExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobPropertiesList = builder.exportJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExportJobPropertiesList() {
        return this.exportJobPropertiesList != null && !(this.exportJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<ExportJobProperties> exportJobPropertiesList() {
        return this.exportJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportJobPropertiesList() ? this.exportJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirExportJobsResponse)) {
            return false;
        }
        ListFhirExportJobsResponse other = (ListFhirExportJobsResponse)((Object)obj);
        return this.hasExportJobPropertiesList() == other.hasExportJobPropertiesList() && Objects.equals(this.exportJobPropertiesList(), other.exportJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFhirExportJobsResponse").add("ExportJobPropertiesList", this.hasExportJobPropertiesList() ? this.exportJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.exportJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExportJobPropertiesList", EXPORT_JOB_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFhirExportJobsResponse, T> g) {
        return obj -> g.apply((ListFhirExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthLakeResponse.BuilderImpl
    implements Builder {
        private List<ExportJobProperties> exportJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirExportJobsResponse model) {
            super(model);
            this.exportJobPropertiesList(model.exportJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<ExportJobProperties.Builder> getExportJobPropertiesList() {
            List<ExportJobProperties.Builder> result = ExportJobPropertiesListCopier.copyToBuilder(this.exportJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportJobPropertiesList(Collection<ExportJobProperties.BuilderImpl> exportJobPropertiesList) {
            this.exportJobPropertiesList = ExportJobPropertiesListCopier.copyFromBuilder(exportJobPropertiesList);
        }

        @Override
        public final Builder exportJobPropertiesList(Collection<ExportJobProperties> exportJobPropertiesList) {
            this.exportJobPropertiesList = ExportJobPropertiesListCopier.copy(exportJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobPropertiesList(ExportJobProperties ... exportJobPropertiesList) {
            this.exportJobPropertiesList(Arrays.asList(exportJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobPropertiesList(Consumer<ExportJobProperties.Builder> ... exportJobPropertiesList) {
            this.exportJobPropertiesList(Stream.of(exportJobPropertiesList).map(c -> (ExportJobProperties)((ExportJobProperties.Builder)ExportJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFhirExportJobsResponse build() {
            return new ListFhirExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFhirExportJobsResponse> {
        public Builder exportJobPropertiesList(Collection<ExportJobProperties> var1);

        public Builder exportJobPropertiesList(ExportJobProperties ... var1);

        public Builder exportJobPropertiesList(Consumer<ExportJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

