/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.healthlake.HealthLakeClient;
import software.amazon.awssdk.services.healthlake.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.HealthLakeRequest;
import software.amazon.awssdk.services.healthlake.waiters.HealthLakeWaiter;
import software.amazon.awssdk.services.healthlake.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultHealthLakeWaiter
implements HealthLakeWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final HealthLakeClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeFhirDatastoreResponse> fHIRDatastoreActiveWaiter;
    private final Waiter<DescribeFhirDatastoreResponse> fHIRDatastoreDeletedWaiter;
    private final Waiter<DescribeFhirExportJobResponse> fHIRExportJobCompletedWaiter;
    private final Waiter<DescribeFhirImportJobResponse> fHIRImportJobCompletedWaiter;

    private DefaultHealthLakeWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (HealthLakeClient)HealthLakeClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.fHIRDatastoreActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFhirDatastoreResponse.class).acceptors(DefaultHealthLakeWaiter.fHIRDatastoreActiveWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeWaiter.fHIRDatastoreActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.fHIRDatastoreDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFhirDatastoreResponse.class).acceptors(DefaultHealthLakeWaiter.fHIRDatastoreDeletedWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeWaiter.fHIRDatastoreDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.fHIRExportJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFhirExportJobResponse.class).acceptors(DefaultHealthLakeWaiter.fHIRExportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeWaiter.fHIRExportJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.fHIRImportJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFhirImportJobResponse.class).acceptors(DefaultHealthLakeWaiter.fHIRImportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeWaiter.fHIRImportJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeFhirDatastoreResponse> waitUntilFHIRDatastoreActive(DescribeFhirDatastoreRequest describeFhirDatastoreRequest) {
        return this.fHIRDatastoreActiveWaiter.run(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)));
    }

    @Override
    public WaiterResponse<DescribeFhirDatastoreResponse> waitUntilFHIRDatastoreActive(DescribeFhirDatastoreRequest describeFhirDatastoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRDatastoreActiveWaiter.run(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)), DefaultHealthLakeWaiter.fHIRDatastoreActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFhirDatastoreResponse> waitUntilFHIRDatastoreDeleted(DescribeFhirDatastoreRequest describeFhirDatastoreRequest) {
        return this.fHIRDatastoreDeletedWaiter.run(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)));
    }

    @Override
    public WaiterResponse<DescribeFhirDatastoreResponse> waitUntilFHIRDatastoreDeleted(DescribeFhirDatastoreRequest describeFhirDatastoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRDatastoreDeletedWaiter.run(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)), DefaultHealthLakeWaiter.fHIRDatastoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFhirExportJobResponse> waitUntilFHIRExportJobCompleted(DescribeFhirExportJobRequest describeFhirExportJobRequest) {
        return this.fHIRExportJobCompletedWaiter.run(() -> this.client.describeFHIRExportJob(this.applyWaitersUserAgent(describeFhirExportJobRequest)));
    }

    @Override
    public WaiterResponse<DescribeFhirExportJobResponse> waitUntilFHIRExportJobCompleted(DescribeFhirExportJobRequest describeFhirExportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRExportJobCompletedWaiter.run(() -> this.client.describeFHIRExportJob(this.applyWaitersUserAgent(describeFhirExportJobRequest)), DefaultHealthLakeWaiter.fHIRExportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFhirImportJobResponse> waitUntilFHIRImportJobCompleted(DescribeFhirImportJobRequest describeFhirImportJobRequest) {
        return this.fHIRImportJobCompletedWaiter.run(() -> this.client.describeFHIRImportJob(this.applyWaitersUserAgent(describeFhirImportJobRequest)));
    }

    @Override
    public WaiterResponse<DescribeFhirImportJobResponse> waitUntilFHIRImportJobCompleted(DescribeFhirImportJobRequest describeFhirImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRImportJobCompletedWaiter.run(() -> this.client.describeFHIRImportJob(this.applyWaitersUserAgent(describeFhirImportJobRequest)), DefaultHealthLakeWaiter.fHIRImportJobCompletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> fHIRDatastoreActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (DatastoreProperties.DatastoreStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (DatastoreProperties.DatastoreStatus=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> fHIRDatastoreDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "DELETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFhirExportJobResponse>> fHIRExportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirExportJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirExportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "COMPLETED_WITH_ERRORS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "CANCEL_COMPLETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExportJobProperties.JobStatus=CANCEL_COMPLETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExportJobProperties.JobStatus=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "CANCEL_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExportJobProperties.JobStatus=CANCEL_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFhirImportJobResponse>> fHIRImportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirImportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportJobProperties").field("JobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportJobProperties").field("JobStatus").value(), "COMPLETED_WITH_ERRORS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportJobProperties").field("JobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ImportJobProperties.JobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration fHIRDatastoreActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fHIRDatastoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fHIRExportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fHIRImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(720);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static HealthLakeWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends HealthLakeRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((HealthLakeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements HealthLakeWaiter.Builder {
        private HealthLakeClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public HealthLakeWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public HealthLakeWaiter.Builder client(HealthLakeClient client) {
            this.client = client;
            return this;
        }

        @Override
        public HealthLakeWaiter build() {
            return new DefaultHealthLakeWaiter(this);
        }
    }
}

