/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationLevel {
    STRICT("strict"),
    STRUCTURE_ONLY("structure-only"),
    MINIMAL("minimal"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationLevel> VALUE_MAP;
    private final String value;

    private ValidationLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationLevel> knownValues() {
        EnumSet<ValidationLevel> knownValues = EnumSet.allOf(ValidationLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationLevel.class, ValidationLevel::toString);
    }
}

