/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.waiters.IamAsyncWaiter;
import software.amazon.awssdk.services.iam.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultIamAsyncWaiter
implements IamAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final IamAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetInstanceProfileResponse> instanceProfileExistsWaiter;
    private final AsyncWaiter<GetUserResponse> userExistsWaiter;
    private final AsyncWaiter<GetRoleResponse> roleExistsWaiter;
    private final AsyncWaiter<GetPolicyResponse> policyExistsWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultIamAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (IamAsyncClient)IamAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.instanceProfileExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetInstanceProfileResponse.class).acceptors(DefaultIamAsyncWaiter.instanceProfileExistsWaiterAcceptors())).overrideConfiguration(DefaultIamAsyncWaiter.instanceProfileExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.userExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetUserResponse.class).acceptors(DefaultIamAsyncWaiter.userExistsWaiterAcceptors())).overrideConfiguration(DefaultIamAsyncWaiter.userExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.roleExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRoleResponse.class).acceptors(DefaultIamAsyncWaiter.roleExistsWaiterAcceptors())).overrideConfiguration(DefaultIamAsyncWaiter.roleExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.policyExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetPolicyResponse.class).acceptors(DefaultIamAsyncWaiter.policyExistsWaiterAcceptors())).overrideConfiguration(DefaultIamAsyncWaiter.policyExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInstanceProfileResponse>> waitUntilInstanceProfileExists(GetInstanceProfileRequest getInstanceProfileRequest) {
        return this.instanceProfileExistsWaiter.runAsync(() -> this.client.getInstanceProfile(this.applyWaitersUserAgent(getInstanceProfileRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInstanceProfileResponse>> waitUntilInstanceProfileExists(GetInstanceProfileRequest getInstanceProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceProfileExistsWaiter.runAsync(() -> this.client.getInstanceProfile(this.applyWaitersUserAgent(getInstanceProfileRequest)), DefaultIamAsyncWaiter.instanceProfileExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPolicyResponse>> waitUntilPolicyExists(GetPolicyRequest getPolicyRequest) {
        return this.policyExistsWaiter.runAsync(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPolicyResponse>> waitUntilPolicyExists(GetPolicyRequest getPolicyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.policyExistsWaiter.runAsync(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)), DefaultIamAsyncWaiter.policyExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRoleResponse>> waitUntilRoleExists(GetRoleRequest getRoleRequest) {
        return this.roleExistsWaiter.runAsync(() -> this.client.getRole(this.applyWaitersUserAgent(getRoleRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRoleResponse>> waitUntilRoleExists(GetRoleRequest getRoleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.roleExistsWaiter.runAsync(() -> this.client.getRole(this.applyWaitersUserAgent(getRoleRequest)), DefaultIamAsyncWaiter.roleExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetUserResponse>> waitUntilUserExists(GetUserRequest getUserRequest) {
        return this.userExistsWaiter.runAsync(() -> this.client.getUser(this.applyWaitersUserAgent(getUserRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetUserResponse>> waitUntilUserExists(GetUserRequest getUserRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.userExistsWaiter.runAsync(() -> this.client.getUser(this.applyWaitersUserAgent(getUserRequest)), DefaultIamAsyncWaiter.userExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetInstanceProfileResponse>> instanceProfileExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetInstanceProfileResponse>> result = new ArrayList<WaiterAcceptor<? super GetInstanceProfileResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetUserResponse>> userExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetUserResponse>> result = new ArrayList<WaiterAcceptor<? super GetUserResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultIamAsyncWaiter.errorCode(error), "NoSuchEntity")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRoleResponse>> roleExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRoleResponse>> result = new ArrayList<WaiterAcceptor<? super GetRoleResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultIamAsyncWaiter.errorCode(error), "NoSuchEntity")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPolicyResponse>> policyExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPolicyResponse>> result = new ArrayList<WaiterAcceptor<? super GetPolicyResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultIamAsyncWaiter.errorCode(error), "NoSuchEntity")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration instanceProfileExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration userExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration roleExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration policyExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static IamAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends IamRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IamRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements IamAsyncWaiter.Builder {
        private IamAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public IamAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public IamAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public IamAsyncWaiter.Builder client(IamAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public IamAsyncWaiter build() {
            return new DefaultIamAsyncWaiter(this);
        }
    }
}

