/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.identitystore.model.MemberId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupMembershipExistenceResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupMembershipExistenceResult> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(GroupMembershipExistenceResult.getter(GroupMembershipExistenceResult::groupId)).setter(GroupMembershipExistenceResult.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemberId").getter(GroupMembershipExistenceResult.getter(GroupMembershipExistenceResult::memberId)).setter(GroupMembershipExistenceResult.setter(Builder::memberId)).constructor(MemberId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<Boolean> MEMBERSHIP_EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MembershipExists").getter(GroupMembershipExistenceResult.getter(GroupMembershipExistenceResult::membershipExists)).setter(GroupMembershipExistenceResult.setter(Builder::membershipExists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipExists").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, MEMBER_ID_FIELD, MEMBERSHIP_EXISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupMembershipExistenceResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final MemberId memberId;
    private final Boolean membershipExists;

    private GroupMembershipExistenceResult(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.memberId = builder.memberId;
        this.membershipExists = builder.membershipExists;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final MemberId memberId() {
        return this.memberId;
    }

    public final Boolean membershipExists() {
        return this.membershipExists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipExists());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupMembershipExistenceResult)) {
            return false;
        }
        GroupMembershipExistenceResult other = (GroupMembershipExistenceResult)obj;
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.membershipExists(), other.membershipExists());
    }

    public final String toString() {
        return ToString.builder((String)"GroupMembershipExistenceResult").add("GroupId", (Object)this.groupId()).add("MemberId", (Object)this.memberId()).add("MembershipExists", (Object)(this.membershipExists() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "MembershipExists": {
                return Optional.ofNullable(clazz.cast(this.membershipExists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("MembershipExists", MEMBERSHIP_EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupMembershipExistenceResult, T> g) {
        return obj -> g.apply((GroupMembershipExistenceResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private MemberId memberId;
        private Boolean membershipExists;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupMembershipExistenceResult model) {
            this.groupId(model.groupId);
            this.memberId(model.memberId);
            this.membershipExists(model.membershipExists);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return this.memberId != null ? this.memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        public final Boolean getMembershipExists() {
            return this.membershipExists;
        }

        public final void setMembershipExists(Boolean membershipExists) {
            this.membershipExists = membershipExists;
        }

        @Override
        public final Builder membershipExists(Boolean membershipExists) {
            this.membershipExists = membershipExists;
            return this;
        }

        public GroupMembershipExistenceResult build() {
            return new GroupMembershipExistenceResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupMembershipExistenceResult> {
        public Builder groupId(String var1);

        public Builder memberId(MemberId var1);

        default public Builder memberId(Consumer<MemberId.Builder> memberId) {
            return this.memberId((MemberId)((MemberId.Builder)MemberId.builder().applyMutation(memberId)).build());
        }

        public Builder membershipExists(Boolean var1);
    }
}

