/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.identitystore.model.ExternalId;
import software.amazon.awssdk.services.identitystore.model.ExternalIdsCopier;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupResponse
extends IdentitystoreResponse
implements ToCopyableBuilder<Builder, DescribeGroupResponse> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(DescribeGroupResponse.getter(DescribeGroupResponse::groupId)).setter(DescribeGroupResponse.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DescribeGroupResponse.getter(DescribeGroupResponse::displayName)).setter(DescribeGroupResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<List<ExternalId>> EXTERNAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExternalIds").getter(DescribeGroupResponse.getter(DescribeGroupResponse::externalIds)).setter(DescribeGroupResponse.setter(Builder::externalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExternalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeGroupResponse.getter(DescribeGroupResponse::description)).setter(DescribeGroupResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeGroupResponse.getter(DescribeGroupResponse::createdAt)).setter(DescribeGroupResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeGroupResponse.getter(DescribeGroupResponse::updatedAt)).setter(DescribeGroupResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(DescribeGroupResponse.getter(DescribeGroupResponse::createdBy)).setter(DescribeGroupResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedBy").getter(DescribeGroupResponse.getter(DescribeGroupResponse::updatedBy)).setter(DescribeGroupResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedBy").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(DescribeGroupResponse.getter(DescribeGroupResponse::identityStoreId)).setter(DescribeGroupResponse.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, DISPLAY_NAME_FIELD, EXTERNAL_IDS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_BY_FIELD, IDENTITY_STORE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGroupResponse.memberNameToFieldInitializer();
    private final String groupId;
    private final String displayName;
    private final List<ExternalId> externalIds;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String createdBy;
    private final String updatedBy;
    private final String identityStoreId;

    private DescribeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.displayName = builder.displayName;
        this.externalIds = builder.externalIds;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.createdBy = builder.createdBy;
        this.updatedBy = builder.updatedBy;
        this.identityStoreId = builder.identityStoreId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasExternalIds() {
        return this.externalIds != null && !(this.externalIds instanceof SdkAutoConstructList);
    }

    public final List<ExternalId> externalIds() {
        return this.externalIds;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalIds() ? this.externalIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupResponse)) {
            return false;
        }
        DescribeGroupResponse other = (DescribeGroupResponse)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.displayName(), other.displayName()) && this.hasExternalIds() == other.hasExternalIds() && Objects.equals(this.externalIds(), other.externalIds()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.identityStoreId(), other.identityStoreId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGroupResponse").add("GroupId", (Object)this.groupId()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("ExternalIds", this.hasExternalIds() ? this.externalIds() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedBy", (Object)this.updatedBy()).add("IdentityStoreId", (Object)this.identityStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ExternalIds": {
                return Optional.ofNullable(clazz.cast(this.externalIds()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "UpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("ExternalIds", EXTERNAL_IDS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("UpdatedBy", UPDATED_BY_FIELD);
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupResponse, T> g) {
        return obj -> g.apply((DescribeGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreResponse.BuilderImpl
    implements Builder {
        private String groupId;
        private String displayName;
        private List<ExternalId> externalIds = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private String createdBy;
        private String updatedBy;
        private String identityStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupResponse model) {
            super(model);
            this.groupId(model.groupId);
            this.displayName(model.displayName);
            this.externalIds(model.externalIds);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.createdBy(model.createdBy);
            this.updatedBy(model.updatedBy);
            this.identityStoreId(model.identityStoreId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<ExternalId.Builder> getExternalIds() {
            List<ExternalId.Builder> result = ExternalIdsCopier.copyToBuilder(this.externalIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalIds(Collection<ExternalId.BuilderImpl> externalIds) {
            this.externalIds = ExternalIdsCopier.copyFromBuilder(externalIds);
        }

        @Override
        public final Builder externalIds(Collection<ExternalId> externalIds) {
            this.externalIds = ExternalIdsCopier.copy(externalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalIds(ExternalId ... externalIds) {
            this.externalIds(Arrays.asList(externalIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalIds(Consumer<ExternalId.Builder> ... externalIds) {
            this.externalIds(Stream.of(externalIds).map(c -> (ExternalId)((ExternalId.Builder)ExternalId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        @Override
        public DescribeGroupResponse build() {
            return new DescribeGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IdentitystoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupResponse> {
        public Builder groupId(String var1);

        public Builder displayName(String var1);

        public Builder externalIds(Collection<ExternalId> var1);

        public Builder externalIds(ExternalId ... var1);

        public Builder externalIds(Consumer<ExternalId.Builder> ... var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedBy(String var1);

        public Builder identityStoreId(String var1);
    }
}

