/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Photo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Photo> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(Photo.getter(Photo::value)).setter(Photo.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Photo.getter(Photo::type)).setter(Photo.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DISPLAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Display").getter(Photo.getter(Photo::display)).setter(Photo.setter(Builder::display)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Display").build()}).build();
    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Primary").getter(Photo.getter(Photo::primary)).setter(Photo.setter(Builder::primary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD, DISPLAY_FIELD, PRIMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Photo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String type;
    private final String display;
    private final Boolean primary;

    private Photo(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.display = builder.display;
        this.primary = builder.primary;
    }

    public final String value() {
        return this.value;
    }

    public final String type() {
        return this.type;
    }

    public final String display() {
        return this.display;
    }

    public final Boolean primary() {
        return this.primary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.display());
        hashCode = 31 * hashCode + Objects.hashCode(this.primary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Photo)) {
            return false;
        }
        Photo other = (Photo)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.display(), other.display()) && Objects.equals(this.primary(), other.primary());
    }

    public final String toString() {
        return ToString.builder((String)"Photo").add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)(this.type() == null ? null : "*** Sensitive Data Redacted ***")).add("Display", (Object)(this.display() == null ? null : "*** Sensitive Data Redacted ***")).add("Primary", (Object)(this.primary() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Display": {
                return Optional.ofNullable(clazz.cast(this.display()));
            }
            case "Primary": {
                return Optional.ofNullable(clazz.cast(this.primary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Display", DISPLAY_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Photo, T> g) {
        return obj -> g.apply((Photo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private String type;
        private String display;
        private Boolean primary;

        private BuilderImpl() {
        }

        private BuilderImpl(Photo model) {
            this.value(model.value);
            this.type(model.type);
            this.display(model.display);
            this.primary(model.primary);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDisplay() {
            return this.display;
        }

        public final void setDisplay(String display) {
            this.display = display;
        }

        @Override
        public final Builder display(String display) {
            this.display = display;
            return this;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public Photo build() {
            return new Photo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Photo> {
        public Builder value(String var1);

        public Builder type(String var1);

        public Builder display(String var1);

        public Builder primary(Boolean var1);
    }
}

