/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerType {
    DOCKER("DOCKER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerType> VALUE_MAP;
    private final String value;

    private ContainerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerType> knownValues() {
        EnumSet<ContainerType> knownValues = EnumSet.allOf(ContainerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerType.class, ContainerType::toString);
    }
}

