/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicySummary;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse;

public class ListLifecyclePoliciesIterable
implements SdkIterable<ListLifecyclePoliciesResponse> {
    private final ImagebuilderClient client;
    private final ListLifecyclePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLifecyclePoliciesIterable(ImagebuilderClient client, ListLifecyclePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLifecyclePoliciesResponseFetcher();
    }

    public Iterator<ListLifecyclePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LifecyclePolicySummary> lifecyclePolicySummaryList() {
        Function<ListLifecyclePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.lifecyclePolicySummaryList() != null) {
                return response.lifecyclePolicySummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLifecyclePoliciesResponseFetcher
    implements SyncPageFetcher<ListLifecyclePoliciesResponse> {
        private ListLifecyclePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListLifecyclePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLifecyclePoliciesResponse nextPage(ListLifecyclePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListLifecyclePoliciesIterable.this.client.listLifecyclePolicies(ListLifecyclePoliciesIterable.this.firstRequest);
            }
            return ListLifecyclePoliciesIterable.this.client.listLifecyclePolicies((ListLifecyclePoliciesRequest)((Object)ListLifecyclePoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

