/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailsCopier;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelection;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyStatus;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicy> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LifecyclePolicy.getter(LifecyclePolicy::arn)).setter(LifecyclePolicy.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LifecyclePolicy.getter(LifecyclePolicy::name)).setter(LifecyclePolicy.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(LifecyclePolicy.getter(LifecyclePolicy::description)).setter(LifecyclePolicy.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LifecyclePolicy.getter(LifecyclePolicy::statusAsString)).setter(LifecyclePolicy.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(LifecyclePolicy.getter(LifecyclePolicy::executionRole)).setter(LifecyclePolicy.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(LifecyclePolicy.getter(LifecyclePolicy::resourceTypeAsString)).setter(LifecyclePolicy.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<LifecyclePolicyDetail>> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyDetails").getter(LifecyclePolicy.getter(LifecyclePolicy::policyDetails)).setter(LifecyclePolicy.setter(Builder::policyDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LifecyclePolicyResourceSelection> RESOURCE_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSelection").getter(LifecyclePolicy.getter(LifecyclePolicy::resourceSelection)).setter(LifecyclePolicy.setter(Builder::resourceSelection)).constructor(LifecyclePolicyResourceSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSelection").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dateCreated").getter(LifecyclePolicy.getter(LifecyclePolicy::dateCreated)).setter(LifecyclePolicy.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dateUpdated").getter(LifecyclePolicy.getter(LifecyclePolicy::dateUpdated)).setter(LifecyclePolicy.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateUpdated").build()}).build();
    private static final SdkField<Instant> DATE_LAST_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dateLastRun").getter(LifecyclePolicy.getter(LifecyclePolicy::dateLastRun)).setter(LifecyclePolicy.setter(Builder::dateLastRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateLastRun").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(LifecyclePolicy.getter(LifecyclePolicy::tags)).setter(LifecyclePolicy.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, EXECUTION_ROLE_FIELD, RESOURCE_TYPE_FIELD, POLICY_DETAILS_FIELD, RESOURCE_SELECTION_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, DATE_LAST_RUN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifecyclePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String status;
    private final String executionRole;
    private final String resourceType;
    private final List<LifecyclePolicyDetail> policyDetails;
    private final LifecyclePolicyResourceSelection resourceSelection;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final Instant dateLastRun;
    private final Map<String, String> tags;

    private LifecyclePolicy(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.executionRole = builder.executionRole;
        this.resourceType = builder.resourceType;
        this.policyDetails = builder.policyDetails;
        this.resourceSelection = builder.resourceSelection;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.dateLastRun = builder.dateLastRun;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final LifecyclePolicyStatus status() {
        return LifecyclePolicyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final LifecyclePolicyResourceType resourceType() {
        return LifecyclePolicyResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasPolicyDetails() {
        return this.policyDetails != null && !(this.policyDetails instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicyDetail> policyDetails() {
        return this.policyDetails;
    }

    public final LifecyclePolicyResourceSelection resourceSelection() {
        return this.resourceSelection;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateUpdated() {
        return this.dateUpdated;
    }

    public final Instant dateLastRun() {
        return this.dateLastRun;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyDetails() ? this.policyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateLastRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasPolicyDetails() == other.hasPolicyDetails() && Objects.equals(this.policyDetails(), other.policyDetails()) && Objects.equals(this.resourceSelection(), other.resourceSelection()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.dateLastRun(), other.dateLastRun()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicy").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("ExecutionRole", (Object)this.executionRole()).add("ResourceType", (Object)this.resourceTypeAsString()).add("PolicyDetails", this.hasPolicyDetails() ? this.policyDetails() : null).add("ResourceSelection", (Object)this.resourceSelection()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("DateLastRun", (Object)this.dateLastRun()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "policyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
            case "resourceSelection": {
                return Optional.ofNullable(clazz.cast(this.resourceSelection()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "dateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "dateLastRun": {
                return Optional.ofNullable(clazz.cast(this.dateLastRun()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("policyDetails", POLICY_DETAILS_FIELD);
        map.put("resourceSelection", RESOURCE_SELECTION_FIELD);
        map.put("dateCreated", DATE_CREATED_FIELD);
        map.put("dateUpdated", DATE_UPDATED_FIELD);
        map.put("dateLastRun", DATE_LAST_RUN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String status;
        private String executionRole;
        private String resourceType;
        private List<LifecyclePolicyDetail> policyDetails = DefaultSdkAutoConstructList.getInstance();
        private LifecyclePolicyResourceSelection resourceSelection;
        private Instant dateCreated;
        private Instant dateUpdated;
        private Instant dateLastRun;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.executionRole(model.executionRole);
            this.resourceType(model.resourceType);
            this.policyDetails(model.policyDetails);
            this.resourceSelection(model.resourceSelection);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.dateLastRun(model.dateLastRun);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(LifecyclePolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<LifecyclePolicyDetail.Builder> getPolicyDetails() {
            List<LifecyclePolicyDetail.Builder> result = LifecyclePolicyDetailsCopier.copyToBuilder(this.policyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyDetails(Collection<LifecyclePolicyDetail.BuilderImpl> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copyFromBuilder(policyDetails);
        }

        @Override
        public final Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copy(policyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(LifecyclePolicyDetail ... policyDetails) {
            this.policyDetails(Arrays.asList(policyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder> ... policyDetails) {
            this.policyDetails(Stream.of(policyDetails).map(c -> (LifecyclePolicyDetail)((LifecyclePolicyDetail.Builder)LifecyclePolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LifecyclePolicyResourceSelection.Builder getResourceSelection() {
            return this.resourceSelection != null ? this.resourceSelection.toBuilder() : null;
        }

        public final void setResourceSelection(LifecyclePolicyResourceSelection.BuilderImpl resourceSelection) {
            this.resourceSelection = resourceSelection != null ? resourceSelection.build() : null;
        }

        @Override
        public final Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection) {
            this.resourceSelection = resourceSelection;
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final Instant getDateLastRun() {
            return this.dateLastRun;
        }

        public final void setDateLastRun(Instant dateLastRun) {
            this.dateLastRun = dateLastRun;
        }

        @Override
        public final Builder dateLastRun(Instant dateLastRun) {
            this.dateLastRun = dateLastRun;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicy> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(LifecyclePolicyStatus var1);

        public Builder executionRole(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(LifecyclePolicyResourceType var1);

        public Builder policyDetails(Collection<LifecyclePolicyDetail> var1);

        public Builder policyDetails(LifecyclePolicyDetail ... var1);

        public Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder> ... var1);

        public Builder resourceSelection(LifecyclePolicyResourceSelection var1);

        default public Builder resourceSelection(Consumer<LifecyclePolicyResourceSelection.Builder> resourceSelection) {
            return this.resourceSelection((LifecyclePolicyResourceSelection)((LifecyclePolicyResourceSelection.Builder)LifecyclePolicyResourceSelection.builder().applyMutation(resourceSelection)).build());
        }

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder dateLastRun(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

