/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SsmParameterDataType {
    TEXT("text"),
    AWS_EC2_IMAGE("aws:ec2:image"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SsmParameterDataType> VALUE_MAP;
    private final String value;

    private SsmParameterDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SsmParameterDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SsmParameterDataType> knownValues() {
        EnumSet<SsmParameterDataType> knownValues = EnumSet.allOf(SsmParameterDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SsmParameterDataType.class, SsmParameterDataType::toString);
    }
}

