/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailsCopier;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelection;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceType;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyStatus;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLifecyclePolicyRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::name)).setter(CreateLifecyclePolicyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::description)).setter(CreateLifecyclePolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::statusAsString)).setter(CreateLifecyclePolicyRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::executionRole)).setter(CreateLifecyclePolicyRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::resourceTypeAsString)).setter(CreateLifecyclePolicyRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<LifecyclePolicyDetail>> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyDetails").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::policyDetails)).setter(CreateLifecyclePolicyRequest.setter(Builder::policyDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LifecyclePolicyResourceSelection> RESOURCE_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSelection").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::resourceSelection)).setter(CreateLifecyclePolicyRequest.setter(Builder::resourceSelection)).constructor(LifecyclePolicyResourceSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSelection").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::tags)).setter(CreateLifecyclePolicyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::clientToken)).setter(CreateLifecyclePolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, EXECUTION_ROLE_FIELD, RESOURCE_TYPE_FIELD, POLICY_DETAILS_FIELD, RESOURCE_SELECTION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLifecyclePolicyRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String status;
    private final String executionRole;
    private final String resourceType;
    private final List<LifecyclePolicyDetail> policyDetails;
    private final LifecyclePolicyResourceSelection resourceSelection;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.executionRole = builder.executionRole;
        this.resourceType = builder.resourceType;
        this.policyDetails = builder.policyDetails;
        this.resourceSelection = builder.resourceSelection;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final LifecyclePolicyStatus status() {
        return LifecyclePolicyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final LifecyclePolicyResourceType resourceType() {
        return LifecyclePolicyResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasPolicyDetails() {
        return this.policyDetails != null && !(this.policyDetails instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicyDetail> policyDetails() {
        return this.policyDetails;
    }

    public final LifecyclePolicyResourceSelection resourceSelection() {
        return this.resourceSelection;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyDetails() ? this.policyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyRequest)) {
            return false;
        }
        CreateLifecyclePolicyRequest other = (CreateLifecyclePolicyRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasPolicyDetails() == other.hasPolicyDetails() && Objects.equals(this.policyDetails(), other.policyDetails()) && Objects.equals(this.resourceSelection(), other.resourceSelection()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLifecyclePolicyRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("ExecutionRole", (Object)this.executionRole()).add("ResourceType", (Object)this.resourceTypeAsString()).add("PolicyDetails", this.hasPolicyDetails() ? this.policyDetails() : null).add("ResourceSelection", (Object)this.resourceSelection()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "policyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
            case "resourceSelection": {
                return Optional.ofNullable(clazz.cast(this.resourceSelection()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("policyDetails", POLICY_DETAILS_FIELD);
        map.put("resourceSelection", RESOURCE_SELECTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String status;
        private String executionRole;
        private String resourceType;
        private List<LifecyclePolicyDetail> policyDetails = DefaultSdkAutoConstructList.getInstance();
        private LifecyclePolicyResourceSelection resourceSelection;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.executionRole(model.executionRole);
            this.resourceType(model.resourceType);
            this.policyDetails(model.policyDetails);
            this.resourceSelection(model.resourceSelection);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(LifecyclePolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<LifecyclePolicyDetail.Builder> getPolicyDetails() {
            List<LifecyclePolicyDetail.Builder> result = LifecyclePolicyDetailsCopier.copyToBuilder(this.policyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyDetails(Collection<LifecyclePolicyDetail.BuilderImpl> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copyFromBuilder(policyDetails);
        }

        @Override
        public final Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copy(policyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(LifecyclePolicyDetail ... policyDetails) {
            this.policyDetails(Arrays.asList(policyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder> ... policyDetails) {
            this.policyDetails(Stream.of(policyDetails).map(c -> (LifecyclePolicyDetail)((LifecyclePolicyDetail.Builder)LifecyclePolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LifecyclePolicyResourceSelection.Builder getResourceSelection() {
            return this.resourceSelection != null ? this.resourceSelection.toBuilder() : null;
        }

        public final void setResourceSelection(LifecyclePolicyResourceSelection.BuilderImpl resourceSelection) {
            this.resourceSelection = resourceSelection != null ? resourceSelection.build() : null;
        }

        @Override
        public final Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection) {
            this.resourceSelection = resourceSelection;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLifecyclePolicyRequest build() {
            return new CreateLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(LifecyclePolicyStatus var1);

        public Builder executionRole(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(LifecyclePolicyResourceType var1);

        public Builder policyDetails(Collection<LifecyclePolicyDetail> var1);

        public Builder policyDetails(LifecyclePolicyDetail ... var1);

        public Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder> ... var1);

        public Builder resourceSelection(LifecyclePolicyResourceSelection var1);

        default public Builder resourceSelection(Consumer<LifecyclePolicyResourceSelection.Builder> resourceSelection) {
            return this.resourceSelection((LifecyclePolicyResourceSelection)((LifecyclePolicyResourceSelection.Builder)LifecyclePolicyResourceSelection.builder().applyMutation(resourceSelection)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

