/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImageLoggingConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributeImageRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, DistributeImageRequest> {
    private static final SdkField<String> SOURCE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceImage").getter(DistributeImageRequest.getter(DistributeImageRequest::sourceImage)).setter(DistributeImageRequest.setter(Builder::sourceImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImage").build()}).build();
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionConfigurationArn").getter(DistributeImageRequest.getter(DistributeImageRequest::distributionConfigurationArn)).setter(DistributeImageRequest.setter(Builder::distributionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(DistributeImageRequest.getter(DistributeImageRequest::executionRole)).setter(DistributeImageRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DistributeImageRequest.getter(DistributeImageRequest::tags)).setter(DistributeImageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DistributeImageRequest.getter(DistributeImageRequest::clientToken)).setter(DistributeImageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ImageLoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingConfiguration").getter(DistributeImageRequest.getter(DistributeImageRequest::loggingConfiguration)).setter(DistributeImageRequest.setter(Builder::loggingConfiguration)).constructor(ImageLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FIELD, DISTRIBUTION_CONFIGURATION_ARN_FIELD, EXECUTION_ROLE_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, LOGGING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DistributeImageRequest.memberNameToFieldInitializer();
    private final String sourceImage;
    private final String distributionConfigurationArn;
    private final String executionRole;
    private final Map<String, String> tags;
    private final String clientToken;
    private final ImageLoggingConfiguration loggingConfiguration;

    private DistributeImageRequest(BuilderImpl builder) {
        super(builder);
        this.sourceImage = builder.sourceImage;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.executionRole = builder.executionRole;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.loggingConfiguration = builder.loggingConfiguration;
    }

    public final String sourceImage() {
        return this.sourceImage;
    }

    public final String distributionConfigurationArn() {
        return this.distributionConfigurationArn;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ImageLoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributeImageRequest)) {
            return false;
        }
        DistributeImageRequest other = (DistributeImageRequest)((Object)obj);
        return Objects.equals(this.sourceImage(), other.sourceImage()) && Objects.equals(this.distributionConfigurationArn(), other.distributionConfigurationArn()) && Objects.equals(this.executionRole(), other.executionRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DistributeImageRequest").add("SourceImage", (Object)this.sourceImage()).add("DistributionConfigurationArn", (Object)this.distributionConfigurationArn()).add("ExecutionRole", (Object)this.executionRole()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceImage": {
                return Optional.ofNullable(clazz.cast(this.sourceImage()));
            }
            case "distributionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.distributionConfigurationArn()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "loggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceImage", SOURCE_IMAGE_FIELD);
        map.put("distributionConfigurationArn", DISTRIBUTION_CONFIGURATION_ARN_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("loggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributeImageRequest, T> g) {
        return obj -> g.apply((DistributeImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String sourceImage;
        private String distributionConfigurationArn;
        private String executionRole;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private ImageLoggingConfiguration loggingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributeImageRequest model) {
            super(model);
            this.sourceImage(model.sourceImage);
            this.distributionConfigurationArn(model.distributionConfigurationArn);
            this.executionRole(model.executionRole);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.loggingConfiguration(model.loggingConfiguration);
        }

        public final String getSourceImage() {
            return this.sourceImage;
        }

        public final void setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
        }

        @Override
        public final Builder sourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ImageLoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(ImageLoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(ImageLoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DistributeImageRequest build() {
            return new DistributeImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DistributeImageRequest> {
        public Builder sourceImage(String var1);

        public Builder distributionConfigurationArn(String var1);

        public Builder executionRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder loggingConfiguration(ImageLoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<ImageLoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((ImageLoggingConfiguration)((ImageLoggingConfiguration.Builder)ImageLoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

