/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowSummary;

public class ListWorkflowBuildVersionsPublisher
implements SdkPublisher<ListWorkflowBuildVersionsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListWorkflowBuildVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowBuildVersionsPublisher(ImagebuilderAsyncClient client, ListWorkflowBuildVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowBuildVersionsPublisher(ImagebuilderAsyncClient client, ListWorkflowBuildVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowBuildVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowBuildVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowSummary> workflowSummaryList() {
        Function<ListWorkflowBuildVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowSummaryList() != null) {
                return response.workflowSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowBuildVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowBuildVersionsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowBuildVersionsResponse> {
        private ListWorkflowBuildVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowBuildVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowBuildVersionsResponse> nextPage(ListWorkflowBuildVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowBuildVersionsPublisher.this.client.listWorkflowBuildVersions(ListWorkflowBuildVersionsPublisher.this.firstRequest);
            }
            return ListWorkflowBuildVersionsPublisher.this.client.listWorkflowBuildVersions((ListWorkflowBuildVersionsRequest)((Object)ListWorkflowBuildVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

