/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisCheckAggregation;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse;

public class ListCisScanResultsAggregatedByChecksPublisher
implements SdkPublisher<ListCisScanResultsAggregatedByChecksResponse> {
    private final Inspector2AsyncClient client;
    private final ListCisScanResultsAggregatedByChecksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCisScanResultsAggregatedByChecksPublisher(Inspector2AsyncClient client, ListCisScanResultsAggregatedByChecksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCisScanResultsAggregatedByChecksPublisher(Inspector2AsyncClient client, ListCisScanResultsAggregatedByChecksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCisScanResultsAggregatedByChecksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCisScanResultsAggregatedByChecksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CisCheckAggregation> checkAggregations() {
        Function<ListCisScanResultsAggregatedByChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.checkAggregations() != null) {
                return response.checkAggregations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCisScanResultsAggregatedByChecksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCisScanResultsAggregatedByChecksResponseFetcher
    implements AsyncPageFetcher<ListCisScanResultsAggregatedByChecksResponse> {
        private ListCisScanResultsAggregatedByChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListCisScanResultsAggregatedByChecksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCisScanResultsAggregatedByChecksResponse> nextPage(ListCisScanResultsAggregatedByChecksResponse previousPage) {
            if (previousPage == null) {
                return ListCisScanResultsAggregatedByChecksPublisher.this.client.listCisScanResultsAggregatedByChecks(ListCisScanResultsAggregatedByChecksPublisher.this.firstRequest);
            }
            return ListCisScanResultsAggregatedByChecksPublisher.this.client.listCisScanResultsAggregatedByChecks((ListCisScanResultsAggregatedByChecksRequest)((Object)ListCisScanResultsAggregatedByChecksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

