/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisScan;
import software.amazon.awssdk.services.inspector2.model.ListCisScansRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScansResponse;

public class ListCisScansPublisher
implements SdkPublisher<ListCisScansResponse> {
    private final Inspector2AsyncClient client;
    private final ListCisScansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCisScansPublisher(Inspector2AsyncClient client, ListCisScansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCisScansPublisher(Inspector2AsyncClient client, ListCisScansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCisScansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCisScansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CisScan> scans() {
        Function<ListCisScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.scans() != null) {
                return response.scans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCisScansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCisScansResponseFetcher
    implements AsyncPageFetcher<ListCisScansResponse> {
        private ListCisScansResponseFetcher() {
        }

        public boolean hasNextPage(ListCisScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCisScansResponse> nextPage(ListCisScansResponse previousPage) {
            if (previousPage == null) {
                return ListCisScansPublisher.this.client.listCisScans(ListCisScansPublisher.this.firstRequest);
            }
            return ListCisScansPublisher.this.client.listCisScans((ListCisScansRequest)((Object)ListCisScansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

