/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.PackageManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VulnerablePackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VulnerablePackage> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(VulnerablePackage.getter(VulnerablePackage::name)).setter(VulnerablePackage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(VulnerablePackage.getter(VulnerablePackage::version)).setter(VulnerablePackage.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> SOURCE_LAYER_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceLayerHash").getter(VulnerablePackage.getter(VulnerablePackage::sourceLayerHash)).setter(VulnerablePackage.setter(Builder::sourceLayerHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLayerHash").build()}).build();
    private static final SdkField<Integer> EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("epoch").getter(VulnerablePackage.getter(VulnerablePackage::epoch)).setter(VulnerablePackage.setter(Builder::epoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epoch").build()}).build();
    private static final SdkField<String> RELEASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("release").getter(VulnerablePackage.getter(VulnerablePackage::release)).setter(VulnerablePackage.setter(Builder::release)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("release").build()}).build();
    private static final SdkField<String> ARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arch").getter(VulnerablePackage.getter(VulnerablePackage::arch)).setter(VulnerablePackage.setter(Builder::arch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arch").build()}).build();
    private static final SdkField<String> PACKAGE_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageManager").getter(VulnerablePackage.getter(VulnerablePackage::packageManagerAsString)).setter(VulnerablePackage.setter(Builder::packageManager)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageManager").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(VulnerablePackage.getter(VulnerablePackage::filePath)).setter(VulnerablePackage.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> FIXED_IN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fixedInVersion").getter(VulnerablePackage.getter(VulnerablePackage::fixedInVersion)).setter(VulnerablePackage.setter(Builder::fixedInVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedInVersion").build()}).build();
    private static final SdkField<String> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remediation").getter(VulnerablePackage.getter(VulnerablePackage::remediation)).setter(VulnerablePackage.setter(Builder::remediation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<String> SOURCE_LAMBDA_LAYER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceLambdaLayerArn").getter(VulnerablePackage.getter(VulnerablePackage::sourceLambdaLayerArn)).setter(VulnerablePackage.setter(Builder::sourceLambdaLayerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLambdaLayerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, SOURCE_LAYER_HASH_FIELD, EPOCH_FIELD, RELEASE_FIELD, ARCH_FIELD, PACKAGE_MANAGER_FIELD, FILE_PATH_FIELD, FIXED_IN_VERSION_FIELD, REMEDIATION_FIELD, SOURCE_LAMBDA_LAYER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VulnerablePackage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;
    private final String sourceLayerHash;
    private final Integer epoch;
    private final String release;
    private final String arch;
    private final String packageManager;
    private final String filePath;
    private final String fixedInVersion;
    private final String remediation;
    private final String sourceLambdaLayerArn;

    private VulnerablePackage(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.sourceLayerHash = builder.sourceLayerHash;
        this.epoch = builder.epoch;
        this.release = builder.release;
        this.arch = builder.arch;
        this.packageManager = builder.packageManager;
        this.filePath = builder.filePath;
        this.fixedInVersion = builder.fixedInVersion;
        this.remediation = builder.remediation;
        this.sourceLambdaLayerArn = builder.sourceLambdaLayerArn;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final String sourceLayerHash() {
        return this.sourceLayerHash;
    }

    public final Integer epoch() {
        return this.epoch;
    }

    public final String release() {
        return this.release;
    }

    public final String arch() {
        return this.arch;
    }

    public final PackageManager packageManager() {
        return PackageManager.fromValue(this.packageManager);
    }

    public final String packageManagerAsString() {
        return this.packageManager;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final String fixedInVersion() {
        return this.fixedInVersion;
    }

    public final String remediation() {
        return this.remediation;
    }

    public final String sourceLambdaLayerArn() {
        return this.sourceLambdaLayerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLayerHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.epoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.release());
        hashCode = 31 * hashCode + Objects.hashCode(this.arch());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageManagerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedInVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLambdaLayerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VulnerablePackage)) {
            return false;
        }
        VulnerablePackage other = (VulnerablePackage)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.sourceLayerHash(), other.sourceLayerHash()) && Objects.equals(this.epoch(), other.epoch()) && Objects.equals(this.release(), other.release()) && Objects.equals(this.arch(), other.arch()) && Objects.equals(this.packageManagerAsString(), other.packageManagerAsString()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.fixedInVersion(), other.fixedInVersion()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.sourceLambdaLayerArn(), other.sourceLambdaLayerArn());
    }

    public final String toString() {
        return ToString.builder((String)"VulnerablePackage").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("SourceLayerHash", (Object)this.sourceLayerHash()).add("Epoch", (Object)this.epoch()).add("Release", (Object)this.release()).add("Arch", (Object)this.arch()).add("PackageManager", (Object)this.packageManagerAsString()).add("FilePath", (Object)this.filePath()).add("FixedInVersion", (Object)this.fixedInVersion()).add("Remediation", (Object)this.remediation()).add("SourceLambdaLayerArn", (Object)this.sourceLambdaLayerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "sourceLayerHash": {
                return Optional.ofNullable(clazz.cast(this.sourceLayerHash()));
            }
            case "epoch": {
                return Optional.ofNullable(clazz.cast(this.epoch()));
            }
            case "release": {
                return Optional.ofNullable(clazz.cast(this.release()));
            }
            case "arch": {
                return Optional.ofNullable(clazz.cast(this.arch()));
            }
            case "packageManager": {
                return Optional.ofNullable(clazz.cast(this.packageManagerAsString()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "fixedInVersion": {
                return Optional.ofNullable(clazz.cast(this.fixedInVersion()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "sourceLambdaLayerArn": {
                return Optional.ofNullable(clazz.cast(this.sourceLambdaLayerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("sourceLayerHash", SOURCE_LAYER_HASH_FIELD);
        map.put("epoch", EPOCH_FIELD);
        map.put("release", RELEASE_FIELD);
        map.put("arch", ARCH_FIELD);
        map.put("packageManager", PACKAGE_MANAGER_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("fixedInVersion", FIXED_IN_VERSION_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("sourceLambdaLayerArn", SOURCE_LAMBDA_LAYER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VulnerablePackage, T> g) {
        return obj -> g.apply((VulnerablePackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String sourceLayerHash;
        private Integer epoch;
        private String release;
        private String arch;
        private String packageManager;
        private String filePath;
        private String fixedInVersion;
        private String remediation;
        private String sourceLambdaLayerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VulnerablePackage model) {
            this.name(model.name);
            this.version(model.version);
            this.sourceLayerHash(model.sourceLayerHash);
            this.epoch(model.epoch);
            this.release(model.release);
            this.arch(model.arch);
            this.packageManager(model.packageManager);
            this.filePath(model.filePath);
            this.fixedInVersion(model.fixedInVersion);
            this.remediation(model.remediation);
            this.sourceLambdaLayerArn(model.sourceLambdaLayerArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getSourceLayerHash() {
            return this.sourceLayerHash;
        }

        public final void setSourceLayerHash(String sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
        }

        @Override
        public final Builder sourceLayerHash(String sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
            return this;
        }

        public final Integer getEpoch() {
            return this.epoch;
        }

        public final void setEpoch(Integer epoch) {
            this.epoch = epoch;
        }

        @Override
        public final Builder epoch(Integer epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getRelease() {
            return this.release;
        }

        public final void setRelease(String release) {
            this.release = release;
        }

        @Override
        public final Builder release(String release) {
            this.release = release;
            return this;
        }

        public final String getArch() {
            return this.arch;
        }

        public final void setArch(String arch) {
            this.arch = arch;
        }

        @Override
        public final Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        public final String getPackageManager() {
            return this.packageManager;
        }

        public final void setPackageManager(String packageManager) {
            this.packageManager = packageManager;
        }

        @Override
        public final Builder packageManager(String packageManager) {
            this.packageManager = packageManager;
            return this;
        }

        @Override
        public final Builder packageManager(PackageManager packageManager) {
            this.packageManager(packageManager == null ? null : packageManager.toString());
            return this;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFixedInVersion() {
            return this.fixedInVersion;
        }

        public final void setFixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
        }

        @Override
        public final Builder fixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
            return this;
        }

        public final String getRemediation() {
            return this.remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSourceLambdaLayerArn() {
            return this.sourceLambdaLayerArn;
        }

        public final void setSourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
        }

        @Override
        public final Builder sourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
            return this;
        }

        public VulnerablePackage build() {
            return new VulnerablePackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VulnerablePackage> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder sourceLayerHash(String var1);

        public Builder epoch(Integer var1);

        public Builder release(String var1);

        public Builder arch(String var1);

        public Builder packageManager(String var1);

        public Builder packageManager(PackageManager var1);

        public Builder filePath(String var1);

        public Builder fixedInVersion(String var1);

        public Builder remediation(String var1);

        public Builder sourceLambdaLayerArn(String var1);
    }
}

