/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AmiSortBy;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmiAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmiAggregation> {
    private static final SdkField<List<StringFilter>> AMIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amis").getter(AmiAggregation.getter(AmiAggregation::amis)).setter(AmiAggregation.setter(Builder::amis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(AmiAggregation.getter(AmiAggregation::sortOrderAsString)).setter(AmiAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(AmiAggregation.getter(AmiAggregation::sortByAsString)).setter(AmiAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmiAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> amis;
    private final String sortOrder;
    private final String sortBy;

    private AmiAggregation(BuilderImpl builder) {
        this.amis = builder.amis;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
    }

    public final boolean hasAmis() {
        return this.amis != null && !(this.amis instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> amis() {
        return this.amis;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final AmiSortBy sortBy() {
        return AmiSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmis() ? this.amis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiAggregation)) {
            return false;
        }
        AmiAggregation other = (AmiAggregation)obj;
        return this.hasAmis() == other.hasAmis() && Objects.equals(this.amis(), other.amis()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AmiAggregation").add("Amis", this.hasAmis() ? this.amis() : null).add("SortOrder", (Object)this.sortOrderAsString()).add("SortBy", (Object)this.sortByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amis": {
                return Optional.ofNullable(clazz.cast(this.amis()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amis", AMIS_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmiAggregation, T> g) {
        return obj -> g.apply((AmiAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> amis = DefaultSdkAutoConstructList.getInstance();
        private String sortOrder;
        private String sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiAggregation model) {
            this.amis(model.amis);
            this.sortOrder(model.sortOrder);
            this.sortBy(model.sortBy);
        }

        public final List<StringFilter.Builder> getAmis() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.amis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmis(Collection<StringFilter.BuilderImpl> amis) {
            this.amis = StringFilterListCopier.copyFromBuilder(amis);
        }

        @Override
        public final Builder amis(Collection<StringFilter> amis) {
            this.amis = StringFilterListCopier.copy(amis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(StringFilter ... amis) {
            this.amis(Arrays.asList(amis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Consumer<StringFilter.Builder> ... amis) {
            this.amis(Stream.of(amis).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(AmiSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public AmiAggregation build() {
            return new AmiAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmiAggregation> {
        public Builder amis(Collection<StringFilter> var1);

        public Builder amis(StringFilter ... var1);

        public Builder amis(Consumer<StringFilter.Builder> ... var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder sortBy(String var1);

        public Builder sortBy(AmiSortBy var1);
    }
}

