/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcrContainerImageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcrContainerImageMetadata> {
    private static final SdkField<List<String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(EcrContainerImageMetadata.getter(EcrContainerImageMetadata::tags)).setter(EcrContainerImageMetadata.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> IMAGE_PULLED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("imagePulledAt").getter(EcrContainerImageMetadata.getter(EcrContainerImageMetadata::imagePulledAt)).setter(EcrContainerImageMetadata.setter(Builder::imagePulledAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePulledAt").build()}).build();
    private static final SdkField<Instant> LAST_IN_USE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastInUseAt").getter(EcrContainerImageMetadata.getter(EcrContainerImageMetadata::lastInUseAt)).setter(EcrContainerImageMetadata.setter(Builder::lastInUseAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastInUseAt").build()}).build();
    private static final SdkField<Long> IN_USE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("inUseCount").getter(EcrContainerImageMetadata.getter(EcrContainerImageMetadata::inUseCount)).setter(EcrContainerImageMetadata.setter(Builder::inUseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, IMAGE_PULLED_AT_FIELD, LAST_IN_USE_AT_FIELD, IN_USE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcrContainerImageMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> tags;
    private final Instant imagePulledAt;
    private final Instant lastInUseAt;
    private final Long inUseCount;

    private EcrContainerImageMetadata(BuilderImpl builder) {
        this.tags = builder.tags;
        this.imagePulledAt = builder.imagePulledAt;
        this.lastInUseAt = builder.lastInUseAt;
        this.inUseCount = builder.inUseCount;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<String> tags() {
        return this.tags;
    }

    public final Instant imagePulledAt() {
        return this.imagePulledAt;
    }

    public final Instant lastInUseAt() {
        return this.lastInUseAt;
    }

    public final Long inUseCount() {
        return this.inUseCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePulledAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastInUseAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcrContainerImageMetadata)) {
            return false;
        }
        EcrContainerImageMetadata other = (EcrContainerImageMetadata)obj;
        return this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.imagePulledAt(), other.imagePulledAt()) && Objects.equals(this.lastInUseAt(), other.lastInUseAt()) && Objects.equals(this.inUseCount(), other.inUseCount());
    }

    public final String toString() {
        return ToString.builder((String)"EcrContainerImageMetadata").add("Tags", this.hasTags() ? this.tags() : null).add("ImagePulledAt", (Object)this.imagePulledAt()).add("LastInUseAt", (Object)this.lastInUseAt()).add("InUseCount", (Object)this.inUseCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "imagePulledAt": {
                return Optional.ofNullable(clazz.cast(this.imagePulledAt()));
            }
            case "lastInUseAt": {
                return Optional.ofNullable(clazz.cast(this.lastInUseAt()));
            }
            case "inUseCount": {
                return Optional.ofNullable(clazz.cast(this.inUseCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tags", TAGS_FIELD);
        map.put("imagePulledAt", IMAGE_PULLED_AT_FIELD);
        map.put("lastInUseAt", LAST_IN_USE_AT_FIELD);
        map.put("inUseCount", IN_USE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcrContainerImageMetadata, T> g) {
        return obj -> g.apply((EcrContainerImageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant imagePulledAt;
        private Instant lastInUseAt;
        private Long inUseCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EcrContainerImageMetadata model) {
            this.tags(model.tags);
            this.imagePulledAt(model.imagePulledAt);
            this.lastInUseAt(model.lastInUseAt);
            this.inUseCount(model.inUseCount);
        }

        public final Collection<String> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public final Builder tags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(String ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final Instant getImagePulledAt() {
            return this.imagePulledAt;
        }

        public final void setImagePulledAt(Instant imagePulledAt) {
            this.imagePulledAt = imagePulledAt;
        }

        @Override
        public final Builder imagePulledAt(Instant imagePulledAt) {
            this.imagePulledAt = imagePulledAt;
            return this;
        }

        public final Instant getLastInUseAt() {
            return this.lastInUseAt;
        }

        public final void setLastInUseAt(Instant lastInUseAt) {
            this.lastInUseAt = lastInUseAt;
        }

        @Override
        public final Builder lastInUseAt(Instant lastInUseAt) {
            this.lastInUseAt = lastInUseAt;
            return this;
        }

        public final Long getInUseCount() {
            return this.inUseCount;
        }

        public final void setInUseCount(Long inUseCount) {
            this.inUseCount = inUseCount;
        }

        @Override
        public final Builder inUseCount(Long inUseCount) {
            this.inUseCount = inUseCount;
            return this;
        }

        public EcrContainerImageMetadata build() {
            return new EcrContainerImageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcrContainerImageMetadata> {
        public Builder tags(Collection<String> var1);

        public Builder tags(String ... var1);

        public Builder imagePulledAt(Instant var1);

        public Builder lastInUseAt(Instant var1);

        public Builder inUseCount(Long var1);
    }
}

