/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterAction {
    NONE("NONE"),
    SUPPRESS("SUPPRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterAction> VALUE_MAP;
    private final String value;

    private FilterAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterAction> knownValues() {
        EnumSet<FilterAction> knownValues = EnumSet.allOf(FilterAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterAction.class, FilterAction::toString);
    }
}

