/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CisScan;
import software.amazon.awssdk.services.inspector2.model.CisScanListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCisScansResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListCisScansResponse> {
    private static final SdkField<List<CisScan>> SCANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scans").getter(ListCisScansResponse.getter(ListCisScansResponse::scans)).setter(ListCisScansResponse.setter(Builder::scans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisScan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCisScansResponse.getter(ListCisScansResponse::nextToken)).setter(ListCisScansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCisScansResponse.memberNameToFieldInitializer();
    private final List<CisScan> scans;
    private final String nextToken;

    private ListCisScansResponse(BuilderImpl builder) {
        super(builder);
        this.scans = builder.scans;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScans() {
        return this.scans != null && !(this.scans instanceof SdkAutoConstructList);
    }

    public final List<CisScan> scans() {
        return this.scans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScans() ? this.scans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScansResponse)) {
            return false;
        }
        ListCisScansResponse other = (ListCisScansResponse)((Object)obj);
        return this.hasScans() == other.hasScans() && Objects.equals(this.scans(), other.scans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCisScansResponse").add("Scans", this.hasScans() ? this.scans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scans": {
                return Optional.ofNullable(clazz.cast(this.scans()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scans", SCANS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCisScansResponse, T> g) {
        return obj -> g.apply((ListCisScansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<CisScan> scans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScansResponse model) {
            super(model);
            this.scans(model.scans);
            this.nextToken(model.nextToken);
        }

        public final List<CisScan.Builder> getScans() {
            List<CisScan.Builder> result = CisScanListCopier.copyToBuilder(this.scans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScans(Collection<CisScan.BuilderImpl> scans) {
            this.scans = CisScanListCopier.copyFromBuilder(scans);
        }

        @Override
        public final Builder scans(Collection<CisScan> scans) {
            this.scans = CisScanListCopier.copy(scans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scans(CisScan ... scans) {
            this.scans(Arrays.asList(scans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scans(Consumer<CisScan.Builder> ... scans) {
            this.scans(Stream.of(scans).map(c -> (CisScan)((CisScan.Builder)CisScan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCisScansResponse build() {
            return new ListCisScansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCisScansResponse> {
        public Builder scans(Collection<CisScan> var1);

        public Builder scans(CisScan ... var1);

        public Builder scans(Consumer<CisScan.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

