/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.FailedAssociationResult;
import software.amazon.awssdk.services.inspector2.model.FailedAssociationResultListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.SuccessfulAssociationResult;
import software.amazon.awssdk.services.inspector2.model.SuccessfulAssociationResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateCodeSecurityScanConfigurationResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, BatchAssociateCodeSecurityScanConfigurationResponse> {
    private static final SdkField<List<FailedAssociationResult>> FAILED_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedAssociations").getter(BatchAssociateCodeSecurityScanConfigurationResponse.getter(BatchAssociateCodeSecurityScanConfigurationResponse::failedAssociations)).setter(BatchAssociateCodeSecurityScanConfigurationResponse.setter(Builder::failedAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedAssociationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SuccessfulAssociationResult>> SUCCESSFUL_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successfulAssociations").getter(BatchAssociateCodeSecurityScanConfigurationResponse.getter(BatchAssociateCodeSecurityScanConfigurationResponse::successfulAssociations)).setter(BatchAssociateCodeSecurityScanConfigurationResponse.setter(Builder::successfulAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulAssociationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ASSOCIATIONS_FIELD, SUCCESSFUL_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAssociateCodeSecurityScanConfigurationResponse.memberNameToFieldInitializer();
    private final List<FailedAssociationResult> failedAssociations;
    private final List<SuccessfulAssociationResult> successfulAssociations;

    private BatchAssociateCodeSecurityScanConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.failedAssociations = builder.failedAssociations;
        this.successfulAssociations = builder.successfulAssociations;
    }

    public final boolean hasFailedAssociations() {
        return this.failedAssociations != null && !(this.failedAssociations instanceof SdkAutoConstructList);
    }

    public final List<FailedAssociationResult> failedAssociations() {
        return this.failedAssociations;
    }

    public final boolean hasSuccessfulAssociations() {
        return this.successfulAssociations != null && !(this.successfulAssociations instanceof SdkAutoConstructList);
    }

    public final List<SuccessfulAssociationResult> successfulAssociations() {
        return this.successfulAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedAssociations() ? this.failedAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulAssociations() ? this.successfulAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateCodeSecurityScanConfigurationResponse)) {
            return false;
        }
        BatchAssociateCodeSecurityScanConfigurationResponse other = (BatchAssociateCodeSecurityScanConfigurationResponse)((Object)obj);
        return this.hasFailedAssociations() == other.hasFailedAssociations() && Objects.equals(this.failedAssociations(), other.failedAssociations()) && this.hasSuccessfulAssociations() == other.hasSuccessfulAssociations() && Objects.equals(this.successfulAssociations(), other.successfulAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateCodeSecurityScanConfigurationResponse").add("FailedAssociations", this.hasFailedAssociations() ? this.failedAssociations() : null).add("SuccessfulAssociations", this.hasSuccessfulAssociations() ? this.successfulAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failedAssociations": {
                return Optional.ofNullable(clazz.cast(this.failedAssociations()));
            }
            case "successfulAssociations": {
                return Optional.ofNullable(clazz.cast(this.successfulAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("failedAssociations", FAILED_ASSOCIATIONS_FIELD);
        map.put("successfulAssociations", SUCCESSFUL_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateCodeSecurityScanConfigurationResponse, T> g) {
        return obj -> g.apply((BatchAssociateCodeSecurityScanConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<FailedAssociationResult> failedAssociations = DefaultSdkAutoConstructList.getInstance();
        private List<SuccessfulAssociationResult> successfulAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateCodeSecurityScanConfigurationResponse model) {
            super(model);
            this.failedAssociations(model.failedAssociations);
            this.successfulAssociations(model.successfulAssociations);
        }

        public final List<FailedAssociationResult.Builder> getFailedAssociations() {
            List<FailedAssociationResult.Builder> result = FailedAssociationResultListCopier.copyToBuilder(this.failedAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAssociations(Collection<FailedAssociationResult.BuilderImpl> failedAssociations) {
            this.failedAssociations = FailedAssociationResultListCopier.copyFromBuilder(failedAssociations);
        }

        @Override
        public final Builder failedAssociations(Collection<FailedAssociationResult> failedAssociations) {
            this.failedAssociations = FailedAssociationResultListCopier.copy(failedAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociations(FailedAssociationResult ... failedAssociations) {
            this.failedAssociations(Arrays.asList(failedAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociations(Consumer<FailedAssociationResult.Builder> ... failedAssociations) {
            this.failedAssociations(Stream.of(failedAssociations).map(c -> (FailedAssociationResult)((FailedAssociationResult.Builder)FailedAssociationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SuccessfulAssociationResult.Builder> getSuccessfulAssociations() {
            List<SuccessfulAssociationResult.Builder> result = SuccessfulAssociationResultListCopier.copyToBuilder(this.successfulAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulAssociations(Collection<SuccessfulAssociationResult.BuilderImpl> successfulAssociations) {
            this.successfulAssociations = SuccessfulAssociationResultListCopier.copyFromBuilder(successfulAssociations);
        }

        @Override
        public final Builder successfulAssociations(Collection<SuccessfulAssociationResult> successfulAssociations) {
            this.successfulAssociations = SuccessfulAssociationResultListCopier.copy(successfulAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulAssociations(SuccessfulAssociationResult ... successfulAssociations) {
            this.successfulAssociations(Arrays.asList(successfulAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulAssociations(Consumer<SuccessfulAssociationResult.Builder> ... successfulAssociations) {
            this.successfulAssociations(Stream.of(successfulAssociations).map(c -> (SuccessfulAssociationResult)((SuccessfulAssociationResult.Builder)SuccessfulAssociationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateCodeSecurityScanConfigurationResponse build() {
            return new BatchAssociateCodeSecurityScanConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateCodeSecurityScanConfigurationResponse> {
        public Builder failedAssociations(Collection<FailedAssociationResult> var1);

        public Builder failedAssociations(FailedAssociationResult ... var1);

        public Builder failedAssociations(Consumer<FailedAssociationResult.Builder> ... var1);

        public Builder successfulAssociations(Collection<SuccessfulAssociationResult> var1);

        public Builder successfulAssociations(SuccessfulAssociationResult ... var1);

        public Builder successfulAssociations(Consumer<SuccessfulAssociationResult.Builder> ... var1);
    }
}

