/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.CisAccountIdListCopier;
import software.amazon.awssdk.services.inspector2.model.TargetResourceTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisTargets
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisTargets> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(CisTargets.getter(CisTargets::accountIds)).setter(CisTargets.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> TARGET_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targetResourceTags").getter(CisTargets.getter(CisTargets::targetResourceTags)).setter(CisTargets.setter(Builder::targetResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, TARGET_RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CisTargets.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> accountIds;
    private final Map<String, List<String>> targetResourceTags;

    private CisTargets(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.targetResourceTags = builder.targetResourceTags;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasTargetResourceTags() {
        return this.targetResourceTags != null && !(this.targetResourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> targetResourceTags() {
        return this.targetResourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceTags() ? this.targetResourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisTargets)) {
            return false;
        }
        CisTargets other = (CisTargets)obj;
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasTargetResourceTags() == other.hasTargetResourceTags() && Objects.equals(this.targetResourceTags(), other.targetResourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CisTargets").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("TargetResourceTags", this.hasTargetResourceTags() ? this.targetResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "targetResourceTags": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("targetResourceTags", TARGET_RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisTargets, T> g) {
        return obj -> g.apply((CisTargets)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> targetResourceTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CisTargets model) {
            this.accountIds(model.accountIds);
            this.targetResourceTags(model.targetResourceTags);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = CisAccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = CisAccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getTargetResourceTags() {
            if (this.targetResourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.targetResourceTags;
        }

        public final void setTargetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
        }

        @Override
        public final Builder targetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
            return this;
        }

        public CisTargets build() {
            return new CisTargets(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisTargets> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder targetResourceTags(Map<String, ? extends Collection<String>> var1);
    }
}

