/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.BuyerDomain;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalName;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceSelector;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceStatus;
import software.amazon.awssdk.services.invoicing.model.SupplierDomain;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcurementPortalPreferenceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcurementPortalPreferenceSummary> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::awsAccountId)).setter(ProcurementPortalPreferenceSummary.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalPreferenceArn").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::procurementPortalPreferenceArn)).setter(ProcurementPortalPreferenceSummary.setter(Builder::procurementPortalPreferenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalPreferenceArn").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalName").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::procurementPortalNameAsString)).setter(ProcurementPortalPreferenceSummary.setter(Builder::procurementPortalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalName").build()}).build();
    private static final SdkField<String> BUYER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerDomain").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::buyerDomainAsString)).setter(ProcurementPortalPreferenceSummary.setter(Builder::buyerDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerDomain").build()}).build();
    private static final SdkField<String> BUYER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerIdentifier").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::buyerIdentifier)).setter(ProcurementPortalPreferenceSummary.setter(Builder::buyerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerIdentifier").build()}).build();
    private static final SdkField<String> SUPPLIER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierDomain").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::supplierDomainAsString)).setter(ProcurementPortalPreferenceSummary.setter(Builder::supplierDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierDomain").build()}).build();
    private static final SdkField<String> SUPPLIER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierIdentifier").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::supplierIdentifier)).setter(ProcurementPortalPreferenceSummary.setter(Builder::supplierIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierIdentifier").build()}).build();
    private static final SdkField<ProcurementPortalPreferenceSelector> SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Selector").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::selector)).setter(ProcurementPortalPreferenceSummary.setter(Builder::selector)).constructor(ProcurementPortalPreferenceSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()}).build();
    private static final SdkField<Boolean> EINVOICE_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EinvoiceDeliveryEnabled").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::einvoiceDeliveryEnabled)).setter(ProcurementPortalPreferenceSummary.setter(Builder::einvoiceDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryEnabled").build()}).build();
    private static final SdkField<Boolean> PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PurchaseOrderRetrievalEnabled").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::purchaseOrderRetrievalEnabled)).setter(ProcurementPortalPreferenceSummary.setter(Builder::purchaseOrderRetrievalEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEnabled").build()}).build();
    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EinvoiceDeliveryPreferenceStatus").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::einvoiceDeliveryPreferenceStatusAsString)).setter(ProcurementPortalPreferenceSummary.setter(Builder::einvoiceDeliveryPreferenceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreferenceStatus").build()}).build();
    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EinvoiceDeliveryPreferenceStatusReason").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::einvoiceDeliveryPreferenceStatusReason)).setter(ProcurementPortalPreferenceSummary.setter(Builder::einvoiceDeliveryPreferenceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreferenceStatusReason").build()}).build();
    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseOrderRetrievalPreferenceStatus").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::purchaseOrderRetrievalPreferenceStatusAsString)).setter(ProcurementPortalPreferenceSummary.setter(Builder::purchaseOrderRetrievalPreferenceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalPreferenceStatus").build()}).build();
    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseOrderRetrievalPreferenceStatusReason").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::purchaseOrderRetrievalPreferenceStatusReason)).setter(ProcurementPortalPreferenceSummary.setter(Builder::purchaseOrderRetrievalPreferenceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalPreferenceStatusReason").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::version)).setter(ProcurementPortalPreferenceSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::createDate)).setter(ProcurementPortalPreferenceSummary.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDate").getter(ProcurementPortalPreferenceSummary.getter(ProcurementPortalPreferenceSummary::lastUpdateDate)).setter(ProcurementPortalPreferenceSummary.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD, PROCUREMENT_PORTAL_NAME_FIELD, BUYER_DOMAIN_FIELD, BUYER_IDENTIFIER_FIELD, SUPPLIER_DOMAIN_FIELD, SUPPLIER_IDENTIFIER_FIELD, SELECTOR_FIELD, EINVOICE_DELIVERY_ENABLED_FIELD, PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD, EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD, EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD, PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD, PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD, VERSION_FIELD, CREATE_DATE_FIELD, LAST_UPDATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProcurementPortalPreferenceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String procurementPortalPreferenceArn;
    private final String procurementPortalName;
    private final String buyerDomain;
    private final String buyerIdentifier;
    private final String supplierDomain;
    private final String supplierIdentifier;
    private final ProcurementPortalPreferenceSelector selector;
    private final Boolean einvoiceDeliveryEnabled;
    private final Boolean purchaseOrderRetrievalEnabled;
    private final String einvoiceDeliveryPreferenceStatus;
    private final String einvoiceDeliveryPreferenceStatusReason;
    private final String purchaseOrderRetrievalPreferenceStatus;
    private final String purchaseOrderRetrievalPreferenceStatusReason;
    private final Long version;
    private final Instant createDate;
    private final Instant lastUpdateDate;

    private ProcurementPortalPreferenceSummary(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.procurementPortalPreferenceArn = builder.procurementPortalPreferenceArn;
        this.procurementPortalName = builder.procurementPortalName;
        this.buyerDomain = builder.buyerDomain;
        this.buyerIdentifier = builder.buyerIdentifier;
        this.supplierDomain = builder.supplierDomain;
        this.supplierIdentifier = builder.supplierIdentifier;
        this.selector = builder.selector;
        this.einvoiceDeliveryEnabled = builder.einvoiceDeliveryEnabled;
        this.purchaseOrderRetrievalEnabled = builder.purchaseOrderRetrievalEnabled;
        this.einvoiceDeliveryPreferenceStatus = builder.einvoiceDeliveryPreferenceStatus;
        this.einvoiceDeliveryPreferenceStatusReason = builder.einvoiceDeliveryPreferenceStatusReason;
        this.purchaseOrderRetrievalPreferenceStatus = builder.purchaseOrderRetrievalPreferenceStatus;
        this.purchaseOrderRetrievalPreferenceStatusReason = builder.purchaseOrderRetrievalPreferenceStatusReason;
        this.version = builder.version;
        this.createDate = builder.createDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String procurementPortalPreferenceArn() {
        return this.procurementPortalPreferenceArn;
    }

    public final ProcurementPortalName procurementPortalName() {
        return ProcurementPortalName.fromValue(this.procurementPortalName);
    }

    public final String procurementPortalNameAsString() {
        return this.procurementPortalName;
    }

    public final BuyerDomain buyerDomain() {
        return BuyerDomain.fromValue(this.buyerDomain);
    }

    public final String buyerDomainAsString() {
        return this.buyerDomain;
    }

    public final String buyerIdentifier() {
        return this.buyerIdentifier;
    }

    public final SupplierDomain supplierDomain() {
        return SupplierDomain.fromValue(this.supplierDomain);
    }

    public final String supplierDomainAsString() {
        return this.supplierDomain;
    }

    public final String supplierIdentifier() {
        return this.supplierIdentifier;
    }

    public final ProcurementPortalPreferenceSelector selector() {
        return this.selector;
    }

    public final Boolean einvoiceDeliveryEnabled() {
        return this.einvoiceDeliveryEnabled;
    }

    public final Boolean purchaseOrderRetrievalEnabled() {
        return this.purchaseOrderRetrievalEnabled;
    }

    public final ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(this.einvoiceDeliveryPreferenceStatus);
    }

    public final String einvoiceDeliveryPreferenceStatusAsString() {
        return this.einvoiceDeliveryPreferenceStatus;
    }

    public final String einvoiceDeliveryPreferenceStatusReason() {
        return this.einvoiceDeliveryPreferenceStatusReason;
    }

    public final ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(this.purchaseOrderRetrievalPreferenceStatus);
    }

    public final String purchaseOrderRetrievalPreferenceStatusAsString() {
        return this.purchaseOrderRetrievalPreferenceStatus;
    }

    public final String purchaseOrderRetrievalPreferenceStatusReason() {
        return this.purchaseOrderRetrievalPreferenceStatusReason;
    }

    public final Long version() {
        return this.version;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.selector());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryPreferenceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalPreferenceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcurementPortalPreferenceSummary)) {
            return false;
        }
        ProcurementPortalPreferenceSummary other = (ProcurementPortalPreferenceSummary)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.procurementPortalPreferenceArn(), other.procurementPortalPreferenceArn()) && Objects.equals(this.procurementPortalNameAsString(), other.procurementPortalNameAsString()) && Objects.equals(this.buyerDomainAsString(), other.buyerDomainAsString()) && Objects.equals(this.buyerIdentifier(), other.buyerIdentifier()) && Objects.equals(this.supplierDomainAsString(), other.supplierDomainAsString()) && Objects.equals(this.supplierIdentifier(), other.supplierIdentifier()) && Objects.equals(this.selector(), other.selector()) && Objects.equals(this.einvoiceDeliveryEnabled(), other.einvoiceDeliveryEnabled()) && Objects.equals(this.purchaseOrderRetrievalEnabled(), other.purchaseOrderRetrievalEnabled()) && Objects.equals(this.einvoiceDeliveryPreferenceStatusAsString(), other.einvoiceDeliveryPreferenceStatusAsString()) && Objects.equals(this.einvoiceDeliveryPreferenceStatusReason(), other.einvoiceDeliveryPreferenceStatusReason()) && Objects.equals(this.purchaseOrderRetrievalPreferenceStatusAsString(), other.purchaseOrderRetrievalPreferenceStatusAsString()) && Objects.equals(this.purchaseOrderRetrievalPreferenceStatusReason(), other.purchaseOrderRetrievalPreferenceStatusReason()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"ProcurementPortalPreferenceSummary").add("AwsAccountId", (Object)this.awsAccountId()).add("ProcurementPortalPreferenceArn", (Object)this.procurementPortalPreferenceArn()).add("ProcurementPortalName", (Object)this.procurementPortalNameAsString()).add("BuyerDomain", (Object)this.buyerDomainAsString()).add("BuyerIdentifier", (Object)this.buyerIdentifier()).add("SupplierDomain", (Object)this.supplierDomainAsString()).add("SupplierIdentifier", (Object)this.supplierIdentifier()).add("Selector", (Object)this.selector()).add("EinvoiceDeliveryEnabled", (Object)this.einvoiceDeliveryEnabled()).add("PurchaseOrderRetrievalEnabled", (Object)this.purchaseOrderRetrievalEnabled()).add("EinvoiceDeliveryPreferenceStatus", (Object)this.einvoiceDeliveryPreferenceStatusAsString()).add("EinvoiceDeliveryPreferenceStatusReason", (Object)this.einvoiceDeliveryPreferenceStatusReason()).add("PurchaseOrderRetrievalPreferenceStatus", (Object)this.purchaseOrderRetrievalPreferenceStatusAsString()).add("PurchaseOrderRetrievalPreferenceStatusReason", (Object)this.purchaseOrderRetrievalPreferenceStatusReason()).add("Version", (Object)this.version()).add("CreateDate", (Object)this.createDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ProcurementPortalPreferenceArn": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalPreferenceArn()));
            }
            case "ProcurementPortalName": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalNameAsString()));
            }
            case "BuyerDomain": {
                return Optional.ofNullable(clazz.cast(this.buyerDomainAsString()));
            }
            case "BuyerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.buyerIdentifier()));
            }
            case "SupplierDomain": {
                return Optional.ofNullable(clazz.cast(this.supplierDomainAsString()));
            }
            case "SupplierIdentifier": {
                return Optional.ofNullable(clazz.cast(this.supplierIdentifier()));
            }
            case "Selector": {
                return Optional.ofNullable(clazz.cast(this.selector()));
            }
            case "EinvoiceDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryEnabled()));
            }
            case "PurchaseOrderRetrievalEnabled": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalEnabled()));
            }
            case "EinvoiceDeliveryPreferenceStatus": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryPreferenceStatusAsString()));
            }
            case "EinvoiceDeliveryPreferenceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryPreferenceStatusReason()));
            }
            case "PurchaseOrderRetrievalPreferenceStatus": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalPreferenceStatusAsString()));
            }
            case "PurchaseOrderRetrievalPreferenceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalPreferenceStatusReason()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "LastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ProcurementPortalPreferenceArn", PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD);
        map.put("ProcurementPortalName", PROCUREMENT_PORTAL_NAME_FIELD);
        map.put("BuyerDomain", BUYER_DOMAIN_FIELD);
        map.put("BuyerIdentifier", BUYER_IDENTIFIER_FIELD);
        map.put("SupplierDomain", SUPPLIER_DOMAIN_FIELD);
        map.put("SupplierIdentifier", SUPPLIER_IDENTIFIER_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("EinvoiceDeliveryEnabled", EINVOICE_DELIVERY_ENABLED_FIELD);
        map.put("PurchaseOrderRetrievalEnabled", PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatus", EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatusReason", EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatus", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatusReason", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("LastUpdateDate", LAST_UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcurementPortalPreferenceSummary, T> g) {
        return obj -> g.apply((ProcurementPortalPreferenceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String procurementPortalPreferenceArn;
        private String procurementPortalName;
        private String buyerDomain;
        private String buyerIdentifier;
        private String supplierDomain;
        private String supplierIdentifier;
        private ProcurementPortalPreferenceSelector selector;
        private Boolean einvoiceDeliveryEnabled;
        private Boolean purchaseOrderRetrievalEnabled;
        private String einvoiceDeliveryPreferenceStatus;
        private String einvoiceDeliveryPreferenceStatusReason;
        private String purchaseOrderRetrievalPreferenceStatus;
        private String purchaseOrderRetrievalPreferenceStatusReason;
        private Long version;
        private Instant createDate;
        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcurementPortalPreferenceSummary model) {
            this.awsAccountId(model.awsAccountId);
            this.procurementPortalPreferenceArn(model.procurementPortalPreferenceArn);
            this.procurementPortalName(model.procurementPortalName);
            this.buyerDomain(model.buyerDomain);
            this.buyerIdentifier(model.buyerIdentifier);
            this.supplierDomain(model.supplierDomain);
            this.supplierIdentifier(model.supplierIdentifier);
            this.selector(model.selector);
            this.einvoiceDeliveryEnabled(model.einvoiceDeliveryEnabled);
            this.purchaseOrderRetrievalEnabled(model.purchaseOrderRetrievalEnabled);
            this.einvoiceDeliveryPreferenceStatus(model.einvoiceDeliveryPreferenceStatus);
            this.einvoiceDeliveryPreferenceStatusReason(model.einvoiceDeliveryPreferenceStatusReason);
            this.purchaseOrderRetrievalPreferenceStatus(model.purchaseOrderRetrievalPreferenceStatus);
            this.purchaseOrderRetrievalPreferenceStatusReason(model.purchaseOrderRetrievalPreferenceStatusReason);
            this.version(model.version);
            this.createDate(model.createDate);
            this.lastUpdateDate(model.lastUpdateDate);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getProcurementPortalPreferenceArn() {
            return this.procurementPortalPreferenceArn;
        }

        public final void setProcurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
        }

        @Override
        public final Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
            return this;
        }

        public final String getProcurementPortalName() {
            return this.procurementPortalName;
        }

        public final void setProcurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
        }

        @Override
        public final Builder procurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
            return this;
        }

        @Override
        public final Builder procurementPortalName(ProcurementPortalName procurementPortalName) {
            this.procurementPortalName(procurementPortalName == null ? null : procurementPortalName.toString());
            return this;
        }

        public final String getBuyerDomain() {
            return this.buyerDomain;
        }

        public final void setBuyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
        }

        @Override
        public final Builder buyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
            return this;
        }

        @Override
        public final Builder buyerDomain(BuyerDomain buyerDomain) {
            this.buyerDomain(buyerDomain == null ? null : buyerDomain.toString());
            return this;
        }

        public final String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        public final void setBuyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
        }

        @Override
        public final Builder buyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
            return this;
        }

        public final String getSupplierDomain() {
            return this.supplierDomain;
        }

        public final void setSupplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
        }

        @Override
        public final Builder supplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
            return this;
        }

        @Override
        public final Builder supplierDomain(SupplierDomain supplierDomain) {
            this.supplierDomain(supplierDomain == null ? null : supplierDomain.toString());
            return this;
        }

        public final String getSupplierIdentifier() {
            return this.supplierIdentifier;
        }

        public final void setSupplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
        }

        @Override
        public final Builder supplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
            return this;
        }

        public final ProcurementPortalPreferenceSelector.Builder getSelector() {
            return this.selector != null ? this.selector.toBuilder() : null;
        }

        public final void setSelector(ProcurementPortalPreferenceSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(ProcurementPortalPreferenceSelector selector) {
            this.selector = selector;
            return this;
        }

        public final Boolean getEinvoiceDeliveryEnabled() {
            return this.einvoiceDeliveryEnabled;
        }

        public final void setEinvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
        }

        @Override
        public final Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
            return this;
        }

        public final Boolean getPurchaseOrderRetrievalEnabled() {
            return this.purchaseOrderRetrievalEnabled;
        }

        public final void setPurchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
        }

        @Override
        public final Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatus() {
            return this.einvoiceDeliveryPreferenceStatus;
        }

        public final void setEinvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus(einvoiceDeliveryPreferenceStatus == null ? null : einvoiceDeliveryPreferenceStatus.toString());
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatusReason() {
            return this.einvoiceDeliveryPreferenceStatusReason;
        }

        public final void setEinvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatus() {
            return this.purchaseOrderRetrievalPreferenceStatus;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
            return this;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus(purchaseOrderRetrievalPreferenceStatus == null ? null : purchaseOrderRetrievalPreferenceStatus.toString());
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatusReason() {
            return this.purchaseOrderRetrievalPreferenceStatusReason;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public ProcurementPortalPreferenceSummary build() {
            return new ProcurementPortalPreferenceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcurementPortalPreferenceSummary> {
        public Builder awsAccountId(String var1);

        public Builder procurementPortalPreferenceArn(String var1);

        public Builder procurementPortalName(String var1);

        public Builder procurementPortalName(ProcurementPortalName var1);

        public Builder buyerDomain(String var1);

        public Builder buyerDomain(BuyerDomain var1);

        public Builder buyerIdentifier(String var1);

        public Builder supplierDomain(String var1);

        public Builder supplierDomain(SupplierDomain var1);

        public Builder supplierIdentifier(String var1);

        public Builder selector(ProcurementPortalPreferenceSelector var1);

        default public Builder selector(Consumer<ProcurementPortalPreferenceSelector.Builder> selector) {
            return this.selector((ProcurementPortalPreferenceSelector)((ProcurementPortalPreferenceSelector.Builder)ProcurementPortalPreferenceSelector.builder().applyMutation(selector)).build());
        }

        public Builder einvoiceDeliveryEnabled(Boolean var1);

        public Builder purchaseOrderRetrievalEnabled(Boolean var1);

        public Builder einvoiceDeliveryPreferenceStatus(String var1);

        public Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus var1);

        public Builder einvoiceDeliveryPreferenceStatusReason(String var1);

        public Builder purchaseOrderRetrievalPreferenceStatus(String var1);

        public Builder purchaseOrderRetrievalPreferenceStatus(ProcurementPortalPreferenceStatus var1);

        public Builder purchaseOrderRetrievalPreferenceStatusReason(String var1);

        public Builder version(Long var1);

        public Builder createDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);
    }
}

