/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.DiscountsBreakdownAmount;
import software.amazon.awssdk.services.invoicing.model.DiscountsBreakdownAmountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscountsBreakdown
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiscountsBreakdown> {
    private static final SdkField<List<DiscountsBreakdownAmount>> BREAKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Breakdown").getter(DiscountsBreakdown.getter(DiscountsBreakdown::breakdown)).setter(DiscountsBreakdown.setter(Builder::breakdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Breakdown").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiscountsBreakdownAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TOTAL_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalAmount").getter(DiscountsBreakdown.getter(DiscountsBreakdown::totalAmount)).setter(DiscountsBreakdown.setter(Builder::totalAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BREAKDOWN_FIELD, TOTAL_AMOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DiscountsBreakdown.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DiscountsBreakdownAmount> breakdown;
    private final String totalAmount;

    private DiscountsBreakdown(BuilderImpl builder) {
        this.breakdown = builder.breakdown;
        this.totalAmount = builder.totalAmount;
    }

    public final boolean hasBreakdown() {
        return this.breakdown != null && !(this.breakdown instanceof SdkAutoConstructList);
    }

    public final List<DiscountsBreakdownAmount> breakdown() {
        return this.breakdown;
    }

    public final String totalAmount() {
        return this.totalAmount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBreakdown() ? this.breakdown() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAmount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscountsBreakdown)) {
            return false;
        }
        DiscountsBreakdown other = (DiscountsBreakdown)obj;
        return this.hasBreakdown() == other.hasBreakdown() && Objects.equals(this.breakdown(), other.breakdown()) && Objects.equals(this.totalAmount(), other.totalAmount());
    }

    public final String toString() {
        return ToString.builder((String)"DiscountsBreakdown").add("Breakdown", this.hasBreakdown() ? this.breakdown() : null).add("TotalAmount", (Object)this.totalAmount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Breakdown": {
                return Optional.ofNullable(clazz.cast(this.breakdown()));
            }
            case "TotalAmount": {
                return Optional.ofNullable(clazz.cast(this.totalAmount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Breakdown", BREAKDOWN_FIELD);
        map.put("TotalAmount", TOTAL_AMOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscountsBreakdown, T> g) {
        return obj -> g.apply((DiscountsBreakdown)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DiscountsBreakdownAmount> breakdown = DefaultSdkAutoConstructList.getInstance();
        private String totalAmount;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscountsBreakdown model) {
            this.breakdown(model.breakdown);
            this.totalAmount(model.totalAmount);
        }

        public final List<DiscountsBreakdownAmount.Builder> getBreakdown() {
            List<DiscountsBreakdownAmount.Builder> result = DiscountsBreakdownAmountListCopier.copyToBuilder(this.breakdown);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBreakdown(Collection<DiscountsBreakdownAmount.BuilderImpl> breakdown) {
            this.breakdown = DiscountsBreakdownAmountListCopier.copyFromBuilder(breakdown);
        }

        @Override
        public final Builder breakdown(Collection<DiscountsBreakdownAmount> breakdown) {
            this.breakdown = DiscountsBreakdownAmountListCopier.copy(breakdown);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder breakdown(DiscountsBreakdownAmount ... breakdown) {
            this.breakdown(Arrays.asList(breakdown));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder breakdown(Consumer<DiscountsBreakdownAmount.Builder> ... breakdown) {
            this.breakdown(Stream.of(breakdown).map(c -> (DiscountsBreakdownAmount)((DiscountsBreakdownAmount.Builder)DiscountsBreakdownAmount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTotalAmount() {
            return this.totalAmount;
        }

        public final void setTotalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Override
        public final Builder totalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public DiscountsBreakdown build() {
            return new DiscountsBreakdown(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiscountsBreakdown> {
        public Builder breakdown(Collection<DiscountsBreakdownAmount> var1);

        public Builder breakdown(DiscountsBreakdownAmount ... var1);

        public Builder breakdown(Consumer<DiscountsBreakdownAmount.Builder> ... var1);

        public Builder totalAmount(String var1);
    }
}

