/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EinvoiceDeliveryDocumentType {
    AWS_CLOUD_INVOICE("AWS_CLOUD_INVOICE"),
    AWS_CLOUD_CREDIT_MEMO("AWS_CLOUD_CREDIT_MEMO"),
    AWS_MARKETPLACE_INVOICE("AWS_MARKETPLACE_INVOICE"),
    AWS_MARKETPLACE_CREDIT_MEMO("AWS_MARKETPLACE_CREDIT_MEMO"),
    AWS_REQUEST_FOR_PAYMENT("AWS_REQUEST_FOR_PAYMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EinvoiceDeliveryDocumentType> VALUE_MAP;
    private final String value;

    private EinvoiceDeliveryDocumentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EinvoiceDeliveryDocumentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EinvoiceDeliveryDocumentType> knownValues() {
        EnumSet<EinvoiceDeliveryDocumentType> knownValues = EnumSet.allOf(EinvoiceDeliveryDocumentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EinvoiceDeliveryDocumentType.class, EinvoiceDeliveryDocumentType::toString);
    }
}

