/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.invoicing.InvoicingAsyncClient;
import software.amazon.awssdk.services.invoicing.internal.UserAgentUtils;
import software.amazon.awssdk.services.invoicing.model.ListProcurementPortalPreferencesRequest;
import software.amazon.awssdk.services.invoicing.model.ListProcurementPortalPreferencesResponse;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceSummary;

public class ListProcurementPortalPreferencesPublisher
implements SdkPublisher<ListProcurementPortalPreferencesResponse> {
    private final InvoicingAsyncClient client;
    private final ListProcurementPortalPreferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProcurementPortalPreferencesPublisher(InvoicingAsyncClient client, ListProcurementPortalPreferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProcurementPortalPreferencesPublisher(InvoicingAsyncClient client, ListProcurementPortalPreferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProcurementPortalPreferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProcurementPortalPreferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProcurementPortalPreferenceSummary> procurementPortalPreferences() {
        Function<ListProcurementPortalPreferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.procurementPortalPreferences() != null) {
                return response.procurementPortalPreferences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProcurementPortalPreferencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProcurementPortalPreferencesResponseFetcher
    implements AsyncPageFetcher<ListProcurementPortalPreferencesResponse> {
        private ListProcurementPortalPreferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListProcurementPortalPreferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProcurementPortalPreferencesResponse> nextPage(ListProcurementPortalPreferencesResponse previousPage) {
            if (previousPage == null) {
                return ListProcurementPortalPreferencesPublisher.this.client.listProcurementPortalPreferences(ListProcurementPortalPreferencesPublisher.this.firstRequest);
            }
            return ListProcurementPortalPreferencesPublisher.this.client.listProcurementPortalPreferences((ListProcurementPortalPreferencesRequest)((Object)ListProcurementPortalPreferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

