/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An asset property value entry containing the following information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetPropertyValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetPropertyValue.Builder, AssetPropertyValue> {
    private static final SdkField<AssetPropertyVariant> VALUE_FIELD = SdkField
            .<AssetPropertyVariant> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(AssetPropertyValue::value)).setter(setter(Builder::value)).constructor(AssetPropertyVariant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<AssetPropertyTimestamp> TIMESTAMP_FIELD = SdkField
            .<AssetPropertyTimestamp> builder(MarshallingType.SDK_POJO).memberName("timestamp")
            .getter(getter(AssetPropertyValue::timestamp)).setter(setter(Builder::timestamp))
            .constructor(AssetPropertyTimestamp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("quality")
            .getter(getter(AssetPropertyValue::quality)).setter(setter(Builder::quality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TIMESTAMP_FIELD,
            QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssetPropertyVariant value;

    private final AssetPropertyTimestamp timestamp;

    private final String quality;

    private AssetPropertyValue(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
        this.quality = builder.quality;
    }

    /**
     * <p>
     * The value of the asset property.
     * </p>
     * 
     * @return The value of the asset property.
     */
    public final AssetPropertyVariant value() {
        return value;
    }

    /**
     * <p>
     * The asset property value timestamp.
     * </p>
     * 
     * @return The asset property value timestamp.
     */
    public final AssetPropertyTimestamp timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Optional. A string that describes the quality of the value. Accepts substitution templates. Must be
     * <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.
     * </p>
     * 
     * @return Optional. A string that describes the quality of the value. Accepts substitution templates. Must be
     *         <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.
     */
    public final String quality() {
        return quality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(quality());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyValue)) {
            return false;
        }
        AssetPropertyValue other = (AssetPropertyValue) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(quality(), other.quality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetPropertyValue").add("Value", value()).add("Timestamp", timestamp())
                .add("Quality", quality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "quality":
            return Optional.ofNullable(clazz.cast(quality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertyValue, T> g) {
        return obj -> g.apply((AssetPropertyValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetPropertyValue> {
        /**
         * <p>
         * The value of the asset property.
         * </p>
         * 
         * @param value
         *        The value of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(AssetPropertyVariant value);

        /**
         * <p>
         * The value of the asset property.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetPropertyVariant.Builder} avoiding the need
         * to create one manually via {@link AssetPropertyVariant#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetPropertyVariant.Builder#build()} is called immediately and
         * its result is passed to {@link #value(AssetPropertyVariant)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link AssetPropertyVariant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(AssetPropertyVariant)
         */
        default Builder value(Consumer<AssetPropertyVariant.Builder> value) {
            return value(AssetPropertyVariant.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The asset property value timestamp.
         * </p>
         * 
         * @param timestamp
         *        The asset property value timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(AssetPropertyTimestamp timestamp);

        /**
         * <p>
         * The asset property value timestamp.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetPropertyTimestamp.Builder} avoiding the
         * need to create one manually via {@link AssetPropertyTimestamp#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetPropertyTimestamp.Builder#build()} is called immediately and
         * its result is passed to {@link #timestamp(AssetPropertyTimestamp)}.
         * 
         * @param timestamp
         *        a consumer that will call methods on {@link AssetPropertyTimestamp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestamp(AssetPropertyTimestamp)
         */
        default Builder timestamp(Consumer<AssetPropertyTimestamp.Builder> timestamp) {
            return timestamp(AssetPropertyTimestamp.builder().applyMutation(timestamp).build());
        }

        /**
         * <p>
         * Optional. A string that describes the quality of the value. Accepts substitution templates. Must be
         * <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.
         * </p>
         * 
         * @param quality
         *        Optional. A string that describes the quality of the value. Accepts substitution templates. Must be
         *        <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quality(String quality);
    }

    static final class BuilderImpl implements Builder {
        private AssetPropertyVariant value;

        private AssetPropertyTimestamp timestamp;

        private String quality;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertyValue model) {
            value(model.value);
            timestamp(model.timestamp);
            quality(model.quality);
        }

        public final AssetPropertyVariant.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(AssetPropertyVariant.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        @Transient
        public final Builder value(AssetPropertyVariant value) {
            this.value = value;
            return this;
        }

        public final AssetPropertyTimestamp.Builder getTimestamp() {
            return timestamp != null ? timestamp.toBuilder() : null;
        }

        public final void setTimestamp(AssetPropertyTimestamp.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        @Override
        @Transient
        public final Builder timestamp(AssetPropertyTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getQuality() {
            return quality;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        @Override
        @Transient
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        @Override
        public AssetPropertyValue build() {
            return new AssetPropertyValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
