/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a custom method used to code sign a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomCodeSigning implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomCodeSigning.Builder, CustomCodeSigning> {
    private static final SdkField<CodeSigningSignature> SIGNATURE_FIELD = SdkField
            .<CodeSigningSignature> builder(MarshallingType.SDK_POJO).memberName("signature")
            .getter(getter(CustomCodeSigning::signature)).setter(setter(Builder::signature))
            .constructor(CodeSigningSignature::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()).build();

    private static final SdkField<CodeSigningCertificateChain> CERTIFICATE_CHAIN_FIELD = SdkField
            .<CodeSigningCertificateChain> builder(MarshallingType.SDK_POJO).memberName("certificateChain")
            .getter(getter(CustomCodeSigning::certificateChain)).setter(setter(Builder::certificateChain))
            .constructor(CodeSigningCertificateChain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateChain").build()).build();

    private static final SdkField<String> HASH_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hashAlgorithm").getter(getter(CustomCodeSigning::hashAlgorithm)).setter(setter(Builder::hashAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashAlgorithm").build()).build();

    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signatureAlgorithm").getter(getter(CustomCodeSigning::signatureAlgorithm))
            .setter(setter(Builder::signatureAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureAlgorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_FIELD,
            CERTIFICATE_CHAIN_FIELD, HASH_ALGORITHM_FIELD, SIGNATURE_ALGORITHM_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeSigningSignature signature;

    private final CodeSigningCertificateChain certificateChain;

    private final String hashAlgorithm;

    private final String signatureAlgorithm;

    private CustomCodeSigning(BuilderImpl builder) {
        this.signature = builder.signature;
        this.certificateChain = builder.certificateChain;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.signatureAlgorithm = builder.signatureAlgorithm;
    }

    /**
     * <p>
     * The signature for the file.
     * </p>
     * 
     * @return The signature for the file.
     */
    public final CodeSigningSignature signature() {
        return signature;
    }

    /**
     * <p>
     * The certificate chain.
     * </p>
     * 
     * @return The certificate chain.
     */
    public final CodeSigningCertificateChain certificateChain() {
        return certificateChain;
    }

    /**
     * <p>
     * The hash algorithm used to code sign the file.
     * </p>
     * 
     * @return The hash algorithm used to code sign the file.
     */
    public final String hashAlgorithm() {
        return hashAlgorithm;
    }

    /**
     * <p>
     * The signature algorithm used to code sign the file.
     * </p>
     * 
     * @return The signature algorithm used to code sign the file.
     */
    public final String signatureAlgorithm() {
        return signatureAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(hashAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(signatureAlgorithm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomCodeSigning)) {
            return false;
        }
        CustomCodeSigning other = (CustomCodeSigning) obj;
        return Objects.equals(signature(), other.signature()) && Objects.equals(certificateChain(), other.certificateChain())
                && Objects.equals(hashAlgorithm(), other.hashAlgorithm())
                && Objects.equals(signatureAlgorithm(), other.signatureAlgorithm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomCodeSigning").add("Signature", signature()).add("CertificateChain", certificateChain())
                .add("HashAlgorithm", hashAlgorithm()).add("SignatureAlgorithm", signatureAlgorithm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signature":
            return Optional.ofNullable(clazz.cast(signature()));
        case "certificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        case "hashAlgorithm":
            return Optional.ofNullable(clazz.cast(hashAlgorithm()));
        case "signatureAlgorithm":
            return Optional.ofNullable(clazz.cast(signatureAlgorithm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomCodeSigning, T> g) {
        return obj -> g.apply((CustomCodeSigning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomCodeSigning> {
        /**
         * <p>
         * The signature for the file.
         * </p>
         * 
         * @param signature
         *        The signature for the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(CodeSigningSignature signature);

        /**
         * <p>
         * The signature for the file.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeSigningSignature.Builder} avoiding the need
         * to create one manually via {@link CodeSigningSignature#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeSigningSignature.Builder#build()} is called immediately and
         * its result is passed to {@link #signature(CodeSigningSignature)}.
         * 
         * @param signature
         *        a consumer that will call methods on {@link CodeSigningSignature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signature(CodeSigningSignature)
         */
        default Builder signature(Consumer<CodeSigningSignature.Builder> signature) {
            return signature(CodeSigningSignature.builder().applyMutation(signature).build());
        }

        /**
         * <p>
         * The certificate chain.
         * </p>
         * 
         * @param certificateChain
         *        The certificate chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(CodeSigningCertificateChain certificateChain);

        /**
         * <p>
         * The certificate chain.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeSigningCertificateChain.Builder} avoiding
         * the need to create one manually via {@link CodeSigningCertificateChain#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeSigningCertificateChain.Builder#build()} is called
         * immediately and its result is passed to {@link #certificateChain(CodeSigningCertificateChain)}.
         * 
         * @param certificateChain
         *        a consumer that will call methods on {@link CodeSigningCertificateChain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateChain(CodeSigningCertificateChain)
         */
        default Builder certificateChain(Consumer<CodeSigningCertificateChain.Builder> certificateChain) {
            return certificateChain(CodeSigningCertificateChain.builder().applyMutation(certificateChain).build());
        }

        /**
         * <p>
         * The hash algorithm used to code sign the file.
         * </p>
         * 
         * @param hashAlgorithm
         *        The hash algorithm used to code sign the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashAlgorithm(String hashAlgorithm);

        /**
         * <p>
         * The signature algorithm used to code sign the file.
         * </p>
         * 
         * @param signatureAlgorithm
         *        The signature algorithm used to code sign the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureAlgorithm(String signatureAlgorithm);
    }

    static final class BuilderImpl implements Builder {
        private CodeSigningSignature signature;

        private CodeSigningCertificateChain certificateChain;

        private String hashAlgorithm;

        private String signatureAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomCodeSigning model) {
            signature(model.signature);
            certificateChain(model.certificateChain);
            hashAlgorithm(model.hashAlgorithm);
            signatureAlgorithm(model.signatureAlgorithm);
        }

        public final CodeSigningSignature.Builder getSignature() {
            return signature != null ? signature.toBuilder() : null;
        }

        public final void setSignature(CodeSigningSignature.BuilderImpl signature) {
            this.signature = signature != null ? signature.build() : null;
        }

        @Override
        @Transient
        public final Builder signature(CodeSigningSignature signature) {
            this.signature = signature;
            return this;
        }

        public final CodeSigningCertificateChain.Builder getCertificateChain() {
            return certificateChain != null ? certificateChain.toBuilder() : null;
        }

        public final void setCertificateChain(CodeSigningCertificateChain.BuilderImpl certificateChain) {
            this.certificateChain = certificateChain != null ? certificateChain.build() : null;
        }

        @Override
        @Transient
        public final Builder certificateChain(CodeSigningCertificateChain certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final String getHashAlgorithm() {
            return hashAlgorithm;
        }

        public final void setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        @Transient
        public final Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public final String getSignatureAlgorithm() {
            return signatureAlgorithm;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        @Transient
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        @Override
        public CustomCodeSigning build() {
            return new CustomCodeSigning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
