/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a domain configuration. A domain configuration specifies custom IoT-specific information about a
 * domain. A domain configuration can be associated with an Amazon Web Services-managed domain (for example,
 * dbc123defghijk.iot.us-west-2.amazonaws.com), a customer managed domain, or a default endpoint.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Data
 * </p>
 * </li>
 * <li>
 * <p>
 * Jobs
 * </p>
 * </li>
 * <li>
 * <p>
 * CredentialProvider
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainConfigurationSummary.Builder, DomainConfigurationSummary> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationName").getter(getter(DomainConfigurationSummary::domainConfigurationName))
            .setter(setter(Builder::domainConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationName").build())
            .build();

    private static final SdkField<String> DOMAIN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationArn").getter(getter(DomainConfigurationSummary::domainConfigurationArn))
            .setter(setter(Builder::domainConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationArn").build())
            .build();

    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceType").getter(getter(DomainConfigurationSummary::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_CONFIGURATION_ARN_FIELD, SERVICE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainConfigurationName;

    private final String domainConfigurationArn;

    private final String serviceType;

    private DomainConfigurationSummary(BuilderImpl builder) {
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainConfigurationArn = builder.domainConfigurationArn;
        this.serviceType = builder.serviceType;
    }

    /**
     * <p>
     * The name of the domain configuration. This value must be unique to a region.
     * </p>
     * 
     * @return The name of the domain configuration. This value must be unique to a region.
     */
    public final String domainConfigurationName() {
        return domainConfigurationName;
    }

    /**
     * <p>
     * The ARN of the domain configuration.
     * </p>
     * 
     * @return The ARN of the domain configuration.
     */
    public final String domainConfigurationArn() {
        return domainConfigurationArn;
    }

    /**
     * <p>
     * The type of service delivered by the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The type of service delivered by the endpoint.
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The type of service delivered by the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The type of service delivered by the endpoint.
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainConfigurationSummary)) {
            return false;
        }
        DomainConfigurationSummary other = (DomainConfigurationSummary) obj;
        return Objects.equals(domainConfigurationName(), other.domainConfigurationName())
                && Objects.equals(domainConfigurationArn(), other.domainConfigurationArn())
                && Objects.equals(serviceTypeAsString(), other.serviceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainConfigurationSummary").add("DomainConfigurationName", domainConfigurationName())
                .add("DomainConfigurationArn", domainConfigurationArn()).add("ServiceType", serviceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainConfigurationName":
            return Optional.ofNullable(clazz.cast(domainConfigurationName()));
        case "domainConfigurationArn":
            return Optional.ofNullable(clazz.cast(domainConfigurationArn()));
        case "serviceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainConfigurationSummary, T> g) {
        return obj -> g.apply((DomainConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainConfigurationSummary> {
        /**
         * <p>
         * The name of the domain configuration. This value must be unique to a region.
         * </p>
         * 
         * @param domainConfigurationName
         *        The name of the domain configuration. This value must be unique to a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationName(String domainConfigurationName);

        /**
         * <p>
         * The ARN of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationArn
         *        The ARN of the domain configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationArn(String domainConfigurationArn);

        /**
         * <p>
         * The type of service delivered by the endpoint.
         * </p>
         * 
         * @param serviceType
         *        The type of service delivered by the endpoint.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The type of service delivered by the endpoint.
         * </p>
         * 
         * @param serviceType
         *        The type of service delivered by the endpoint.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);
    }

    static final class BuilderImpl implements Builder {
        private String domainConfigurationName;

        private String domainConfigurationArn;

        private String serviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainConfigurationSummary model) {
            domainConfigurationName(model.domainConfigurationName);
            domainConfigurationArn(model.domainConfigurationArn);
            serviceType(model.serviceType);
        }

        public final String getDomainConfigurationName() {
            return domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        @Transient
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final String getDomainConfigurationArn() {
            return domainConfigurationArn;
        }

        public final void setDomainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
        }

        @Override
        @Transient
        public final Builder domainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        @Transient
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        @Transient
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        @Override
        public DomainConfigurationSummary build() {
            return new DomainConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
