/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditMitigationActionsTasksResponse extends IotResponse implements
        ToCopyableBuilder<ListAuditMitigationActionsTasksResponse.Builder, ListAuditMitigationActionsTasksResponse> {
    private static final SdkField<List<AuditMitigationActionsTaskMetadata>> TASKS_FIELD = SdkField
            .<List<AuditMitigationActionsTaskMetadata>> builder(MarshallingType.LIST)
            .memberName("tasks")
            .getter(getter(ListAuditMitigationActionsTasksResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditMitigationActionsTaskMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditMitigationActionsTaskMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAuditMitigationActionsTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AuditMitigationActionsTaskMetadata> tasks;

    private final String nextToken;

    private ListAuditMitigationActionsTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tasks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of audit mitigation tasks that matched the filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTasks} method.
     * </p>
     * 
     * @return The collection of audit mitigation tasks that matched the filter criteria.
     */
    public final List<AuditMitigationActionsTaskMetadata> tasks() {
        return tasks;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditMitigationActionsTasksResponse)) {
            return false;
        }
        ListAuditMitigationActionsTasksResponse other = (ListAuditMitigationActionsTasksResponse) obj;
        return hasTasks() == other.hasTasks() && Objects.equals(tasks(), other.tasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAuditMitigationActionsTasksResponse").add("Tasks", hasTasks() ? tasks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditMitigationActionsTasksResponse, T> g) {
        return obj -> g.apply((ListAuditMitigationActionsTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAuditMitigationActionsTasksResponse> {
        /**
         * <p>
         * The collection of audit mitigation tasks that matched the filter criteria.
         * </p>
         * 
         * @param tasks
         *        The collection of audit mitigation tasks that matched the filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<AuditMitigationActionsTaskMetadata> tasks);

        /**
         * <p>
         * The collection of audit mitigation tasks that matched the filter criteria.
         * </p>
         * 
         * @param tasks
         *        The collection of audit mitigation tasks that matched the filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(AuditMitigationActionsTaskMetadata... tasks);

        /**
         * <p>
         * The collection of audit mitigation tasks that matched the filter criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AuditMitigationActionsTaskMetadata>.Builder} avoiding the need to create one manually via {@link List
         * <AuditMitigationActionsTaskMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuditMitigationActionsTaskMetadata>.Builder#build()} is
         * called immediately and its result is passed to {@link #tasks(List<AuditMitigationActionsTaskMetadata>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on {@link List<AuditMitigationActionsTaskMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(List<AuditMitigationActionsTaskMetadata>)
         */
        Builder tasks(Consumer<AuditMitigationActionsTaskMetadata.Builder>... tasks);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuditMitigationActionsTaskMetadata> tasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditMitigationActionsTasksResponse model) {
            super(model);
            tasks(model.tasks);
            nextToken(model.nextToken);
        }

        public final List<AuditMitigationActionsTaskMetadata.Builder> getTasks() {
            List<AuditMitigationActionsTaskMetadata.Builder> result = AuditMitigationActionsTaskMetadataListCopier
                    .copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<AuditMitigationActionsTaskMetadata.BuilderImpl> tasks) {
            this.tasks = AuditMitigationActionsTaskMetadataListCopier.copyFromBuilder(tasks);
        }

        @Override
        @Transient
        public final Builder tasks(Collection<AuditMitigationActionsTaskMetadata> tasks) {
            this.tasks = AuditMitigationActionsTaskMetadataListCopier.copy(tasks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tasks(AuditMitigationActionsTaskMetadata... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tasks(Consumer<AuditMitigationActionsTaskMetadata.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> AuditMitigationActionsTaskMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuditMitigationActionsTasksResponse build() {
            return new ListAuditMitigationActionsTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
