/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the percentile and percentile value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PercentPair implements SdkPojo, Serializable, ToCopyableBuilder<PercentPair.Builder, PercentPair> {
    private static final SdkField<Double> PERCENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("percent")
            .getter(getter(PercentPair::percent)).setter(setter(Builder::percent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percent").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(PercentPair::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double percent;

    private final Double value;

    private PercentPair(BuilderImpl builder) {
        this.percent = builder.percent;
        this.value = builder.value;
    }

    /**
     * <p>
     * The percentile.
     * </p>
     * 
     * @return The percentile.
     */
    public final Double percent() {
        return percent;
    }

    /**
     * <p>
     * The value of the percentile.
     * </p>
     * 
     * @return The value of the percentile.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percent());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PercentPair)) {
            return false;
        }
        PercentPair other = (PercentPair) obj;
        return Objects.equals(percent(), other.percent()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PercentPair").add("Percent", percent()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "percent":
            return Optional.ofNullable(clazz.cast(percent()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PercentPair, T> g) {
        return obj -> g.apply((PercentPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PercentPair> {
        /**
         * <p>
         * The percentile.
         * </p>
         * 
         * @param percent
         *        The percentile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percent(Double percent);

        /**
         * <p>
         * The value of the percentile.
         * </p>
         * 
         * @param value
         *        The value of the percentile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private Double percent;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(PercentPair model) {
            percent(model.percent);
            value(model.value);
        }

        public final Double getPercent() {
            return percent;
        }

        public final void setPercent(Double percent) {
            this.percent = percent;
        }

        @Override
        @Transient
        public final Builder percent(Double percent) {
            this.percent = percent;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public PercentPair build() {
            return new PercentPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
