/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for pre-signed S3 URLs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PresignedUrlConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PresignedUrlConfig.Builder, PresignedUrlConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(PresignedUrlConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Long> EXPIRES_IN_SEC_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("expiresInSec").getter(getter(PresignedUrlConfig::expiresInSec)).setter(setter(Builder::expiresInSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresInSec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            EXPIRES_IN_SEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final Long expiresInSec;

    private PresignedUrlConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.expiresInSec = builder.expiresInSec;
    }

    /**
     * <p>
     * The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
     * data/updates are stored. The role must also grant permission for IoT to download the files.
     * </p>
     * 
     * @return The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
     *         data/updates are stored. The role must also grant permission for IoT to download the files.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600 seconds.
     * Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
     * </p>
     * 
     * @return How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
     *         seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
     */
    public final Long expiresInSec() {
        return expiresInSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(expiresInSec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresignedUrlConfig)) {
            return false;
        }
        PresignedUrlConfig other = (PresignedUrlConfig) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(expiresInSec(), other.expiresInSec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PresignedUrlConfig").add("RoleArn", roleArn()).add("ExpiresInSec", expiresInSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "expiresInSec":
            return Optional.ofNullable(clazz.cast(expiresInSec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PresignedUrlConfig, T> g) {
        return obj -> g.apply((PresignedUrlConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PresignedUrlConfig> {
        /**
         * <p>
         * The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
         * data/updates are stored. The role must also grant permission for IoT to download the files.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the
         *        job data/updates are stored. The role must also grant permission for IoT to download the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
         * seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
         * </p>
         * 
         * @param expiresInSec
         *        How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
         *        seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresInSec(Long expiresInSec);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private Long expiresInSec;

        private BuilderImpl() {
        }

        private BuilderImpl(PresignedUrlConfig model) {
            roleArn(model.roleArn);
            expiresInSec(model.expiresInSec);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Long getExpiresInSec() {
            return expiresInSec;
        }

        public final void setExpiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
        }

        @Override
        @Transient
        public final Builder expiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
            return this;
        }

        @Override
        public PresignedUrlConfig build() {
            return new PresignedUrlConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
