/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthenticationType {
    CUSTOM_AUTH_X509("CUSTOM_AUTH_X509"),
    CUSTOM_AUTH("CUSTOM_AUTH"),
    AWS_X509("AWS_X509"),
    AWS_SIGV4("AWS_SIGV4"),
    DEFAULT("DEFAULT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthenticationType> VALUE_MAP;
    private final String value;

    private AuthenticationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationType> knownValues() {
        EnumSet<AuthenticationType> knownValues = EnumSet.allOf(AuthenticationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthenticationType.class, AuthenticationType::toString);
    }
}

