/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DimensionNamesCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDimensionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListDimensionsResponse> {
    private static final SdkField<List<String>> DIMENSION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dimensionNames").getter(ListDimensionsResponse.getter(ListDimensionsResponse::dimensionNames)).setter(ListDimensionsResponse.setter(Builder::dimensionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDimensionsResponse.getter(ListDimensionsResponse::nextToken)).setter(ListDimensionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDimensionsResponse.memberNameToFieldInitializer();
    private final List<String> dimensionNames;
    private final String nextToken;

    private ListDimensionsResponse(BuilderImpl builder) {
        super(builder);
        this.dimensionNames = builder.dimensionNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDimensionNames() {
        return this.dimensionNames != null && !(this.dimensionNames instanceof SdkAutoConstructList);
    }

    public final List<String> dimensionNames() {
        return this.dimensionNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionNames() ? this.dimensionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDimensionsResponse)) {
            return false;
        }
        ListDimensionsResponse other = (ListDimensionsResponse)((Object)obj);
        return this.hasDimensionNames() == other.hasDimensionNames() && Objects.equals(this.dimensionNames(), other.dimensionNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDimensionsResponse").add("DimensionNames", this.hasDimensionNames() ? this.dimensionNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dimensionNames": {
                return Optional.ofNullable(clazz.cast(this.dimensionNames()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dimensionNames", DIMENSION_NAMES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDimensionsResponse, T> g) {
        return obj -> g.apply((ListDimensionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> dimensionNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDimensionsResponse model) {
            super(model);
            this.dimensionNames(model.dimensionNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDimensionNames() {
            if (this.dimensionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionNames;
        }

        public final void setDimensionNames(Collection<String> dimensionNames) {
            this.dimensionNames = DimensionNamesCopier.copy(dimensionNames);
        }

        @Override
        public final Builder dimensionNames(Collection<String> dimensionNames) {
            this.dimensionNames = DimensionNamesCopier.copy(dimensionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionNames(String ... dimensionNames) {
            this.dimensionNames(Arrays.asList(dimensionNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDimensionsResponse build() {
            return new ListDimensionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDimensionsResponse> {
        public Builder dimensionNames(Collection<String> var1);

        public Builder dimensionNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

