/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackageRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdatePackageRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(UpdatePackageRequest.getter(UpdatePackageRequest::packageName)).setter(UpdatePackageRequest.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("packageName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdatePackageRequest.getter(UpdatePackageRequest::description)).setter(UpdatePackageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVersionName").getter(UpdatePackageRequest.getter(UpdatePackageRequest::defaultVersionName)).setter(UpdatePackageRequest.setter(Builder::defaultVersionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionName").build()}).build();
    private static final SdkField<Boolean> UNSET_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("unsetDefaultVersion").getter(UpdatePackageRequest.getter(UpdatePackageRequest::unsetDefaultVersion)).setter(UpdatePackageRequest.setter(Builder::unsetDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsetDefaultVersion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdatePackageRequest.getter(UpdatePackageRequest::clientToken)).setter(UpdatePackageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_VERSION_NAME_FIELD, UNSET_DEFAULT_VERSION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePackageRequest.memberNameToFieldInitializer();
    private final String packageName;
    private final String description;
    private final String defaultVersionName;
    private final Boolean unsetDefaultVersion;
    private final String clientToken;

    private UpdatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.description = builder.description;
        this.defaultVersionName = builder.defaultVersionName;
        this.unsetDefaultVersion = builder.unsetDefaultVersion;
        this.clientToken = builder.clientToken;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String description() {
        return this.description;
    }

    public final String defaultVersionName() {
        return this.defaultVersionName;
    }

    public final Boolean unsetDefaultVersion() {
        return this.unsetDefaultVersion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsetDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageRequest)) {
            return false;
        }
        UpdatePackageRequest other = (UpdatePackageRequest)((Object)obj);
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultVersionName(), other.defaultVersionName()) && Objects.equals(this.unsetDefaultVersion(), other.unsetDefaultVersion()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePackageRequest").add("PackageName", (Object)this.packageName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DefaultVersionName", (Object)this.defaultVersionName()).add("UnsetDefaultVersion", (Object)this.unsetDefaultVersion()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "defaultVersionName": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionName()));
            }
            case "unsetDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.unsetDefaultVersion()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("defaultVersionName", DEFAULT_VERSION_NAME_FIELD);
        map.put("unsetDefaultVersion", UNSET_DEFAULT_VERSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageRequest, T> g) {
        return obj -> g.apply((UpdatePackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String packageName;
        private String description;
        private String defaultVersionName;
        private Boolean unsetDefaultVersion;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageRequest model) {
            super(model);
            this.packageName(model.packageName);
            this.description(model.description);
            this.defaultVersionName(model.defaultVersionName);
            this.unsetDefaultVersion(model.unsetDefaultVersion);
            this.clientToken(model.clientToken);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultVersionName() {
            return this.defaultVersionName;
        }

        public final void setDefaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
        }

        @Override
        public final Builder defaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
            return this;
        }

        public final Boolean getUnsetDefaultVersion() {
            return this.unsetDefaultVersion;
        }

        public final void setUnsetDefaultVersion(Boolean unsetDefaultVersion) {
            this.unsetDefaultVersion = unsetDefaultVersion;
        }

        @Override
        public final Builder unsetDefaultVersion(Boolean unsetDefaultVersion) {
            this.unsetDefaultVersion = unsetDefaultVersion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageRequest build() {
            return new UpdatePackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackageRequest> {
        public Builder packageName(String var1);

        public Builder description(String var1);

        public Builder defaultVersionName(String var1);

        public Builder unsetDefaultVersion(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

