/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsV2Request;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsV2Response;
import software.amazon.awssdk.services.iot.model.PrincipalThingObject;

public class ListPrincipalThingsV2Iterable
implements SdkIterable<ListPrincipalThingsV2Response> {
    private final IotClient client;
    private final ListPrincipalThingsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrincipalThingsV2Iterable(IotClient client, ListPrincipalThingsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrincipalThingsV2ResponseFetcher();
    }

    public Iterator<ListPrincipalThingsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrincipalThingObject> principalThingObjects() {
        Function<ListPrincipalThingsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.principalThingObjects() != null) {
                return response.principalThingObjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPrincipalThingsV2ResponseFetcher
    implements SyncPageFetcher<ListPrincipalThingsV2Response> {
        private ListPrincipalThingsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalThingsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPrincipalThingsV2Response nextPage(ListPrincipalThingsV2Response previousPage) {
            if (previousPage == null) {
                return ListPrincipalThingsV2Iterable.this.client.listPrincipalThingsV2(ListPrincipalThingsV2Iterable.this.firstRequest);
            }
            return ListPrincipalThingsV2Iterable.this.client.listPrincipalThingsV2((ListPrincipalThingsV2Request)((Object)ListPrincipalThingsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

