/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchConfig> {
    private static final SdkField<Integer> MAX_BATCH_OPEN_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBatchOpenMs").getter(BatchConfig.getter(BatchConfig::maxBatchOpenMs)).setter(BatchConfig.setter(Builder::maxBatchOpenMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchOpenMs").build()}).build();
    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBatchSize").getter(BatchConfig.getter(BatchConfig::maxBatchSize)).setter(BatchConfig.setter(Builder::maxBatchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()}).build();
    private static final SdkField<Integer> MAX_BATCH_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBatchSizeBytes").getter(BatchConfig.getter(BatchConfig::maxBatchSizeBytes)).setter(BatchConfig.setter(Builder::maxBatchSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSizeBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_BATCH_OPEN_MS_FIELD, MAX_BATCH_SIZE_FIELD, MAX_BATCH_SIZE_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxBatchOpenMs;
    private final Integer maxBatchSize;
    private final Integer maxBatchSizeBytes;

    private BatchConfig(BuilderImpl builder) {
        this.maxBatchOpenMs = builder.maxBatchOpenMs;
        this.maxBatchSize = builder.maxBatchSize;
        this.maxBatchSizeBytes = builder.maxBatchSizeBytes;
    }

    public final Integer maxBatchOpenMs() {
        return this.maxBatchOpenMs;
    }

    public final Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public final Integer maxBatchSizeBytes() {
        return this.maxBatchSizeBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchOpenMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchSizeBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchConfig)) {
            return false;
        }
        BatchConfig other = (BatchConfig)obj;
        return Objects.equals(this.maxBatchOpenMs(), other.maxBatchOpenMs()) && Objects.equals(this.maxBatchSize(), other.maxBatchSize()) && Objects.equals(this.maxBatchSizeBytes(), other.maxBatchSizeBytes());
    }

    public final String toString() {
        return ToString.builder((String)"BatchConfig").add("MaxBatchOpenMs", (Object)this.maxBatchOpenMs()).add("MaxBatchSize", (Object)this.maxBatchSize()).add("MaxBatchSizeBytes", (Object)this.maxBatchSizeBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxBatchOpenMs": {
                return Optional.ofNullable(clazz.cast(this.maxBatchOpenMs()));
            }
            case "maxBatchSize": {
                return Optional.ofNullable(clazz.cast(this.maxBatchSize()));
            }
            case "maxBatchSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.maxBatchSizeBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("maxBatchOpenMs", MAX_BATCH_OPEN_MS_FIELD);
        map.put("maxBatchSize", MAX_BATCH_SIZE_FIELD);
        map.put("maxBatchSizeBytes", MAX_BATCH_SIZE_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchConfig, T> g) {
        return obj -> g.apply((BatchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxBatchOpenMs;
        private Integer maxBatchSize;
        private Integer maxBatchSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchConfig model) {
            this.maxBatchOpenMs(model.maxBatchOpenMs);
            this.maxBatchSize(model.maxBatchSize);
            this.maxBatchSizeBytes(model.maxBatchSizeBytes);
        }

        public final Integer getMaxBatchOpenMs() {
            return this.maxBatchOpenMs;
        }

        public final void setMaxBatchOpenMs(Integer maxBatchOpenMs) {
            this.maxBatchOpenMs = maxBatchOpenMs;
        }

        @Override
        public final Builder maxBatchOpenMs(Integer maxBatchOpenMs) {
            this.maxBatchOpenMs = maxBatchOpenMs;
            return this;
        }

        public final Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final Integer getMaxBatchSizeBytes() {
            return this.maxBatchSizeBytes;
        }

        public final void setMaxBatchSizeBytes(Integer maxBatchSizeBytes) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
        }

        @Override
        public final Builder maxBatchSizeBytes(Integer maxBatchSizeBytes) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
            return this;
        }

        public BatchConfig build() {
            return new BatchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchConfig> {
        public Builder maxBatchOpenMs(Integer var1);

        public Builder maxBatchSize(Integer var1);

        public Builder maxBatchSizeBytes(Integer var1);
    }
}

