/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CommandNamespace;
import software.amazon.awssdk.services.iot.model.CommandParameter;
import software.amazon.awssdk.services.iot.model.CommandParameterListCopier;
import software.amazon.awssdk.services.iot.model.CommandPayload;
import software.amazon.awssdk.services.iot.model.CommandPreprocessor;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCommandRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateCommandRequest> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandId").getter(CreateCommandRequest.getter(CreateCommandRequest::commandId)).setter(CreateCommandRequest.setter(Builder::commandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("commandId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(CreateCommandRequest.getter(CreateCommandRequest::namespaceAsString)).setter(CreateCommandRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateCommandRequest.getter(CreateCommandRequest::displayName)).setter(CreateCommandRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateCommandRequest.getter(CreateCommandRequest::description)).setter(CreateCommandRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<CommandPayload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("payload").getter(CreateCommandRequest.getter(CreateCommandRequest::payload)).setter(CreateCommandRequest.setter(Builder::payload)).constructor(CommandPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<String> PAYLOAD_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payloadTemplate").getter(CreateCommandRequest.getter(CreateCommandRequest::payloadTemplate)).setter(CreateCommandRequest.setter(Builder::payloadTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadTemplate").build()}).build();
    private static final SdkField<CommandPreprocessor> PREPROCESSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preprocessor").getter(CreateCommandRequest.getter(CreateCommandRequest::preprocessor)).setter(CreateCommandRequest.setter(Builder::preprocessor)).constructor(CommandPreprocessor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preprocessor").build()}).build();
    private static final SdkField<List<CommandParameter>> MANDATORY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mandatoryParameters").getter(CreateCommandRequest.getter(CreateCommandRequest::mandatoryParameters)).setter(CreateCommandRequest.setter(Builder::mandatoryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mandatoryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateCommandRequest.getter(CreateCommandRequest::roleArn)).setter(CreateCommandRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateCommandRequest.getter(CreateCommandRequest::tags)).setter(CreateCommandRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD, NAMESPACE_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, PAYLOAD_FIELD, PAYLOAD_TEMPLATE_FIELD, PREPROCESSOR_FIELD, MANDATORY_PARAMETERS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCommandRequest.memberNameToFieldInitializer();
    private final String commandId;
    private final String namespace;
    private final String displayName;
    private final String description;
    private final CommandPayload payload;
    private final String payloadTemplate;
    private final CommandPreprocessor preprocessor;
    private final List<CommandParameter> mandatoryParameters;
    private final String roleArn;
    private final List<Tag> tags;

    private CreateCommandRequest(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.namespace = builder.namespace;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.payload = builder.payload;
        this.payloadTemplate = builder.payloadTemplate;
        this.preprocessor = builder.preprocessor;
        this.mandatoryParameters = builder.mandatoryParameters;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String commandId() {
        return this.commandId;
    }

    public final CommandNamespace namespace() {
        return CommandNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final CommandPayload payload() {
        return this.payload;
    }

    public final String payloadTemplate() {
        return this.payloadTemplate;
    }

    public final CommandPreprocessor preprocessor() {
        return this.preprocessor;
    }

    public final boolean hasMandatoryParameters() {
        return this.mandatoryParameters != null && !(this.mandatoryParameters instanceof SdkAutoConstructList);
    }

    public final List<CommandParameter> mandatoryParameters() {
        return this.mandatoryParameters;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.preprocessor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMandatoryParameters() ? this.mandatoryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommandRequest)) {
            return false;
        }
        CreateCommandRequest other = (CreateCommandRequest)((Object)obj);
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.payloadTemplate(), other.payloadTemplate()) && Objects.equals(this.preprocessor(), other.preprocessor()) && this.hasMandatoryParameters() == other.hasMandatoryParameters() && Objects.equals(this.mandatoryParameters(), other.mandatoryParameters()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCommandRequest").add("CommandId", (Object)this.commandId()).add("Namespace", (Object)this.namespaceAsString()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("Payload", (Object)this.payload()).add("PayloadTemplate", (Object)this.payloadTemplate()).add("Preprocessor", (Object)this.preprocessor()).add("MandatoryParameters", this.hasMandatoryParameters() ? this.mandatoryParameters() : null).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commandId": {
                return Optional.ofNullable(clazz.cast(this.commandId()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "payloadTemplate": {
                return Optional.ofNullable(clazz.cast(this.payloadTemplate()));
            }
            case "preprocessor": {
                return Optional.ofNullable(clazz.cast(this.preprocessor()));
            }
            case "mandatoryParameters": {
                return Optional.ofNullable(clazz.cast(this.mandatoryParameters()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commandId", COMMAND_ID_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("payloadTemplate", PAYLOAD_TEMPLATE_FIELD);
        map.put("preprocessor", PREPROCESSOR_FIELD);
        map.put("mandatoryParameters", MANDATORY_PARAMETERS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCommandRequest, T> g) {
        return obj -> g.apply((CreateCommandRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String commandId;
        private String namespace;
        private String displayName;
        private String description;
        private CommandPayload payload;
        private String payloadTemplate;
        private CommandPreprocessor preprocessor;
        private List<CommandParameter> mandatoryParameters = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommandRequest model) {
            super(model);
            this.commandId(model.commandId);
            this.namespace(model.namespace);
            this.displayName(model.displayName);
            this.description(model.description);
            this.payload(model.payload);
            this.payloadTemplate(model.payloadTemplate);
            this.preprocessor(model.preprocessor);
            this.mandatoryParameters(model.mandatoryParameters);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(CommandNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CommandPayload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(CommandPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(CommandPayload payload) {
            this.payload = payload;
            return this;
        }

        public final String getPayloadTemplate() {
            return this.payloadTemplate;
        }

        public final void setPayloadTemplate(String payloadTemplate) {
            this.payloadTemplate = payloadTemplate;
        }

        @Override
        public final Builder payloadTemplate(String payloadTemplate) {
            this.payloadTemplate = payloadTemplate;
            return this;
        }

        public final CommandPreprocessor.Builder getPreprocessor() {
            return this.preprocessor != null ? this.preprocessor.toBuilder() : null;
        }

        public final void setPreprocessor(CommandPreprocessor.BuilderImpl preprocessor) {
            this.preprocessor = preprocessor != null ? preprocessor.build() : null;
        }

        @Override
        public final Builder preprocessor(CommandPreprocessor preprocessor) {
            this.preprocessor = preprocessor;
            return this;
        }

        public final List<CommandParameter.Builder> getMandatoryParameters() {
            List<CommandParameter.Builder> result = CommandParameterListCopier.copyToBuilder(this.mandatoryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMandatoryParameters(Collection<CommandParameter.BuilderImpl> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copyFromBuilder(mandatoryParameters);
        }

        @Override
        public final Builder mandatoryParameters(Collection<CommandParameter> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copy(mandatoryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(CommandParameter ... mandatoryParameters) {
            this.mandatoryParameters(Arrays.asList(mandatoryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(Consumer<CommandParameter.Builder> ... mandatoryParameters) {
            this.mandatoryParameters(Stream.of(mandatoryParameters).map(c -> (CommandParameter)((CommandParameter.Builder)CommandParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCommandRequest build() {
            return new CreateCommandRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCommandRequest> {
        public Builder commandId(String var1);

        public Builder namespace(String var1);

        public Builder namespace(CommandNamespace var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder payload(CommandPayload var1);

        default public Builder payload(Consumer<CommandPayload.Builder> payload) {
            return this.payload((CommandPayload)((CommandPayload.Builder)CommandPayload.builder().applyMutation(payload)).build());
        }

        public Builder payloadTemplate(String var1);

        public Builder preprocessor(CommandPreprocessor var1);

        default public Builder preprocessor(Consumer<CommandPreprocessor.Builder> preprocessor) {
            return this.preprocessor((CommandPreprocessor)((CommandPreprocessor.Builder)CommandPreprocessor.builder().applyMutation(preprocessor)).build());
        }

        public Builder mandatoryParameters(Collection<CommandParameter> var1);

        public Builder mandatoryParameters(CommandParameter ... var1);

        public Builder mandatoryParameters(Consumer<CommandParameter.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

