/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogEventConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogEventConfiguration> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(LogEventConfiguration.getter(LogEventConfiguration::eventType)).setter(LogEventConfiguration.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(LogEventConfiguration.getter(LogEventConfiguration::logLevelAsString)).setter(LogEventConfiguration.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logDestination").getter(LogEventConfiguration.getter(LogEventConfiguration::logDestination)).setter(LogEventConfiguration.setter(Builder::logDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, LOG_LEVEL_FIELD, LOG_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogEventConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final String logLevel;
    private final String logDestination;

    private LogEventConfiguration(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.logLevel = builder.logLevel;
        this.logDestination = builder.logDestination;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final String logDestination() {
        return this.logDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogEventConfiguration)) {
            return false;
        }
        LogEventConfiguration other = (LogEventConfiguration)obj;
        return Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.logDestination(), other.logDestination());
    }

    public final String toString() {
        return ToString.builder((String)"LogEventConfiguration").add("EventType", (Object)this.eventType()).add("LogLevel", (Object)this.logLevelAsString()).add("LogDestination", (Object)this.logDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "logDestination": {
                return Optional.ofNullable(clazz.cast(this.logDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("logDestination", LOG_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogEventConfiguration, T> g) {
        return obj -> g.apply((LogEventConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private String logLevel;
        private String logDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(LogEventConfiguration model) {
            this.eventType(model.eventType);
            this.logLevel(model.logLevel);
            this.logDestination(model.logDestination);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getLogDestination() {
            return this.logDestination;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        public LogEventConfiguration build() {
            return new LogEventConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogEventConfiguration> {
        public Builder eventType(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder logDestination(String var1);
    }
}

