/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPolicyPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyPrincipalsResponse;

public class ListPolicyPrincipalsPublisher
implements SdkPublisher<ListPolicyPrincipalsResponse> {
    private final IotAsyncClient client;
    private final ListPolicyPrincipalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyPrincipalsPublisher(IotAsyncClient client, ListPolicyPrincipalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyPrincipalsPublisher(IotAsyncClient client, ListPolicyPrincipalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyPrincipalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyPrincipalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> principals() {
        Function<ListPolicyPrincipalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.principals() != null) {
                return response.principals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyPrincipalsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyPrincipalsResponseFetcher
    implements AsyncPageFetcher<ListPolicyPrincipalsResponse> {
        private ListPolicyPrincipalsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyPrincipalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListPolicyPrincipalsResponse> nextPage(ListPolicyPrincipalsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyPrincipalsPublisher.this.client.listPolicyPrincipals(ListPolicyPrincipalsPublisher.this.firstRequest);
            }
            return ListPolicyPrincipalsPublisher.this.client.listPolicyPrincipals((ListPolicyPrincipalsRequest)((Object)ListPolicyPrincipalsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

