/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeDeviceMethodRequest extends Iot1ClickDevicesRequest implements
        ToCopyableBuilder<InvokeDeviceMethodRequest.Builder, InvokeDeviceMethodRequest> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(InvokeDeviceMethodRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("deviceId").build()).build();

    private static final SdkField<DeviceMethod> DEVICE_METHOD_FIELD = SdkField.<DeviceMethod> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceMethod").getter(getter(InvokeDeviceMethodRequest::deviceMethod))
            .setter(setter(Builder::deviceMethod)).constructor(DeviceMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMethod").build()).build();

    private static final SdkField<String> DEVICE_METHOD_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceMethodParameters").getter(getter(InvokeDeviceMethodRequest::deviceMethodParameters))
            .setter(setter(Builder::deviceMethodParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMethodParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD,
            DEVICE_METHOD_FIELD, DEVICE_METHOD_PARAMETERS_FIELD));

    private final String deviceId;

    private final DeviceMethod deviceMethod;

    private final String deviceMethodParameters;

    private InvokeDeviceMethodRequest(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.deviceMethod = builder.deviceMethod;
        this.deviceMethodParameters = builder.deviceMethodParameters;
    }

    /**
     * <p>
     * The unique identifier of the device.
     * </p>
     * 
     * @return The unique identifier of the device.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The device method to invoke.
     * </p>
     * 
     * @return The device method to invoke.
     */
    public final DeviceMethod deviceMethod() {
        return deviceMethod;
    }

    /**
     * <p>
     * A JSON encoded string containing the device method request parameters.
     * </p>
     * 
     * @return A JSON encoded string containing the device method request parameters.
     */
    public final String deviceMethodParameters() {
        return deviceMethodParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMethod());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMethodParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeDeviceMethodRequest)) {
            return false;
        }
        InvokeDeviceMethodRequest other = (InvokeDeviceMethodRequest) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(deviceMethod(), other.deviceMethod())
                && Objects.equals(deviceMethodParameters(), other.deviceMethodParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeDeviceMethodRequest").add("DeviceId", deviceId()).add("DeviceMethod", deviceMethod())
                .add("DeviceMethodParameters", deviceMethodParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "DeviceMethod":
            return Optional.ofNullable(clazz.cast(deviceMethod()));
        case "DeviceMethodParameters":
            return Optional.ofNullable(clazz.cast(deviceMethodParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeDeviceMethodRequest, T> g) {
        return obj -> g.apply((InvokeDeviceMethodRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeDeviceMethodRequest> {
        /**
         * <p>
         * The unique identifier of the device.
         * </p>
         * 
         * @param deviceId
         *        The unique identifier of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The device method to invoke.
         * </p>
         * 
         * @param deviceMethod
         *        The device method to invoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMethod(DeviceMethod deviceMethod);

        /**
         * <p>
         * The device method to invoke.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceMethod.Builder} avoiding the need to
         * create one manually via {@link DeviceMethod#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceMethod.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMethod(DeviceMethod)}.
         * 
         * @param deviceMethod
         *        a consumer that will call methods on {@link DeviceMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMethod(DeviceMethod)
         */
        default Builder deviceMethod(Consumer<DeviceMethod.Builder> deviceMethod) {
            return deviceMethod(DeviceMethod.builder().applyMutation(deviceMethod).build());
        }

        /**
         * <p>
         * A JSON encoded string containing the device method request parameters.
         * </p>
         * 
         * @param deviceMethodParameters
         *        A JSON encoded string containing the device method request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMethodParameters(String deviceMethodParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickDevicesRequest.BuilderImpl implements Builder {
        private String deviceId;

        private DeviceMethod deviceMethod;

        private String deviceMethodParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeDeviceMethodRequest model) {
            super(model);
            deviceId(model.deviceId);
            deviceMethod(model.deviceMethod);
            deviceMethodParameters(model.deviceMethodParameters);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final DeviceMethod.Builder getDeviceMethod() {
            return deviceMethod != null ? deviceMethod.toBuilder() : null;
        }

        public final void setDeviceMethod(DeviceMethod.BuilderImpl deviceMethod) {
            this.deviceMethod = deviceMethod != null ? deviceMethod.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceMethod(DeviceMethod deviceMethod) {
            this.deviceMethod = deviceMethod;
            return this;
        }

        public final String getDeviceMethodParameters() {
            return deviceMethodParameters;
        }

        public final void setDeviceMethodParameters(String deviceMethodParameters) {
            this.deviceMethodParameters = deviceMethodParameters;
        }

        @Override
        @Transient
        public final Builder deviceMethodParameters(String deviceMethodParameters) {
            this.deviceMethodParameters = deviceMethodParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeDeviceMethodRequest build() {
            return new InvokeDeviceMethodRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
