/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsAsyncClient;
import software.amazon.awssdk.services.iotanalytics.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse;

public class ListDatasetContentsPublisher
implements SdkPublisher<ListDatasetContentsResponse> {
    private final IoTAnalyticsAsyncClient client;
    private final ListDatasetContentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetContentsPublisher(IoTAnalyticsAsyncClient client, ListDatasetContentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetContentsPublisher(IoTAnalyticsAsyncClient client, ListDatasetContentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetContentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetContentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDatasetContentsResponseFetcher
    implements AsyncPageFetcher<ListDatasetContentsResponse> {
        private ListDatasetContentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetContentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetContentsResponse> nextPage(ListDatasetContentsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetContentsPublisher.this.client.listDatasetContents(ListDatasetContentsPublisher.this.firstRequest);
            }
            return ListDatasetContentsPublisher.this.client.listDatasetContents((ListDatasetContentsRequest)((Object)ListDatasetContentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

