/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.services.iotanalytics.model.MessagePayloadsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunPipelineActivityResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, RunPipelineActivityResponse> {
    private static final SdkField<List<SdkBytes>> PAYLOADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("payloads").getter(RunPipelineActivityResponse.getter(RunPipelineActivityResponse::payloads)).setter(RunPipelineActivityResponse.setter(Builder::payloads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloads").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOG_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logResult").getter(RunPipelineActivityResponse.getter(RunPipelineActivityResponse::logResult)).setter(RunPipelineActivityResponse.setter(Builder::logResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOADS_FIELD, LOG_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RunPipelineActivityResponse.memberNameToFieldInitializer();
    private final List<SdkBytes> payloads;
    private final String logResult;

    private RunPipelineActivityResponse(BuilderImpl builder) {
        super(builder);
        this.payloads = builder.payloads;
        this.logResult = builder.logResult;
    }

    public final boolean hasPayloads() {
        return this.payloads != null && !(this.payloads instanceof SdkAutoConstructList);
    }

    public final List<SdkBytes> payloads() {
        return this.payloads;
    }

    public final String logResult() {
        return this.logResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPayloads() ? this.payloads() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunPipelineActivityResponse)) {
            return false;
        }
        RunPipelineActivityResponse other = (RunPipelineActivityResponse)((Object)obj);
        return this.hasPayloads() == other.hasPayloads() && Objects.equals(this.payloads(), other.payloads()) && Objects.equals(this.logResult(), other.logResult());
    }

    public final String toString() {
        return ToString.builder((String)"RunPipelineActivityResponse").add("Payloads", this.hasPayloads() ? this.payloads() : null).add("LogResult", (Object)this.logResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "payloads": {
                return Optional.ofNullable(clazz.cast(this.payloads()));
            }
            case "logResult": {
                return Optional.ofNullable(clazz.cast(this.logResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("payloads", PAYLOADS_FIELD);
        map.put("logResult", LOG_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunPipelineActivityResponse, T> g) {
        return obj -> g.apply((RunPipelineActivityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private List<SdkBytes> payloads = DefaultSdkAutoConstructList.getInstance();
        private String logResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RunPipelineActivityResponse model) {
            super(model);
            this.payloads(model.payloads);
            this.logResult(model.logResult);
        }

        public final List<ByteBuffer> getPayloads() {
            if (this.payloads instanceof SdkAutoConstructList) {
                return null;
            }
            return this.payloads == null ? null : this.payloads.stream().map(BytesWrapper::asByteBuffer).collect(Collectors.toList());
        }

        public final void setPayloads(Collection<ByteBuffer> payloads) {
            this.payloads(payloads == null ? null : (Collection)payloads.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        @Override
        public final Builder payloads(Collection<SdkBytes> payloads) {
            this.payloads = MessagePayloadsCopier.copy(payloads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloads(SdkBytes ... payloads) {
            this.payloads(Arrays.asList(payloads));
            return this;
        }

        public final String getLogResult() {
            return this.logResult;
        }

        public final void setLogResult(String logResult) {
            this.logResult = logResult;
        }

        @Override
        public final Builder logResult(String logResult) {
            this.logResult = logResult;
            return this;
        }

        @Override
        public RunPipelineActivityResponse build() {
            return new RunPipelineActivityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunPipelineActivityResponse> {
        public Builder payloads(Collection<SdkBytes> var1);

        public Builder payloads(SdkBytes ... var1);

        public Builder logResult(String var1);
    }
}

