/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.ChannelMessages;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPipelineReprocessingRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, StartPipelineReprocessingRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(StartPipelineReprocessingRequest.getter(StartPipelineReprocessingRequest::pipelineName)).setter(StartPipelineReprocessingRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("pipelineName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StartPipelineReprocessingRequest.getter(StartPipelineReprocessingRequest::startTime)).setter(StartPipelineReprocessingRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StartPipelineReprocessingRequest.getter(StartPipelineReprocessingRequest::endTime)).setter(StartPipelineReprocessingRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<ChannelMessages> CHANNEL_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channelMessages").getter(StartPipelineReprocessingRequest.getter(StartPipelineReprocessingRequest::channelMessages)).setter(StartPipelineReprocessingRequest.setter(Builder::channelMessages)).constructor(ChannelMessages::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelMessages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, CHANNEL_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartPipelineReprocessingRequest.memberNameToFieldInitializer();
    private final String pipelineName;
    private final Instant startTime;
    private final Instant endTime;
    private final ChannelMessages channelMessages;

    private StartPipelineReprocessingRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.channelMessages = builder.channelMessages;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ChannelMessages channelMessages() {
        return this.channelMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelMessages());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineReprocessingRequest)) {
            return false;
        }
        StartPipelineReprocessingRequest other = (StartPipelineReprocessingRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.channelMessages(), other.channelMessages());
    }

    public final String toString() {
        return ToString.builder((String)"StartPipelineReprocessingRequest").add("PipelineName", (Object)this.pipelineName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ChannelMessages", (Object)this.channelMessages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "channelMessages": {
                return Optional.ofNullable(clazz.cast(this.channelMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("channelMessages", CHANNEL_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPipelineReprocessingRequest, T> g) {
        return obj -> g.apply((StartPipelineReprocessingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private Instant startTime;
        private Instant endTime;
        private ChannelMessages channelMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPipelineReprocessingRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.channelMessages(model.channelMessages);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ChannelMessages.Builder getChannelMessages() {
            return this.channelMessages != null ? this.channelMessages.toBuilder() : null;
        }

        public final void setChannelMessages(ChannelMessages.BuilderImpl channelMessages) {
            this.channelMessages = channelMessages != null ? channelMessages.build() : null;
        }

        @Override
        public final Builder channelMessages(ChannelMessages channelMessages) {
            this.channelMessages = channelMessages;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPipelineReprocessingRequest build() {
            return new StartPipelineReprocessingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPipelineReprocessingRequest> {
        public Builder pipelineName(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder channelMessages(ChannelMessages var1);

        default public Builder channelMessages(Consumer<ChannelMessages.Builder> channelMessages) {
            return this.channelMessages((ChannelMessages)((ChannelMessages.Builder)ChannelMessages.builder().applyMutation(channelMessages)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

