/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelPipelineReprocessingRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, CancelPipelineReprocessingRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(CancelPipelineReprocessingRequest.getter(CancelPipelineReprocessingRequest::pipelineName)).setter(CancelPipelineReprocessingRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("pipelineName").build()}).build();
    private static final SdkField<String> REPROCESSING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reprocessingId").getter(CancelPipelineReprocessingRequest.getter(CancelPipelineReprocessingRequest::reprocessingId)).setter(CancelPipelineReprocessingRequest.setter(Builder::reprocessingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("reprocessingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, REPROCESSING_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelPipelineReprocessingRequest.memberNameToFieldInitializer();
    private final String pipelineName;
    private final String reprocessingId;

    private CancelPipelineReprocessingRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.reprocessingId = builder.reprocessingId;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String reprocessingId() {
        return this.reprocessingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reprocessingId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelPipelineReprocessingRequest)) {
            return false;
        }
        CancelPipelineReprocessingRequest other = (CancelPipelineReprocessingRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.reprocessingId(), other.reprocessingId());
    }

    public final String toString() {
        return ToString.builder((String)"CancelPipelineReprocessingRequest").add("PipelineName", (Object)this.pipelineName()).add("ReprocessingId", (Object)this.reprocessingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "reprocessingId": {
                return Optional.ofNullable(clazz.cast(this.reprocessingId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("reprocessingId", REPROCESSING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelPipelineReprocessingRequest, T> g) {
        return obj -> g.apply((CancelPipelineReprocessingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String reprocessingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelPipelineReprocessingRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.reprocessingId(model.reprocessingId);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getReprocessingId() {
            return this.reprocessingId;
        }

        public final void setReprocessingId(String reprocessingId) {
            this.reprocessingId = reprocessingId;
        }

        @Override
        public final Builder reprocessingId(String reprocessingId) {
            this.reprocessingId = reprocessingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelPipelineReprocessingRequest build() {
            return new CancelPipelineReprocessingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelPipelineReprocessingRequest> {
        public Builder pipelineName(String var1);

        public Builder reprocessingId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

