/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotdataplane.model.IotDataPlaneRequest;
import software.amazon.awssdk.services.iotdataplane.model.PayloadFormatIndicator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishRequest
extends IotDataPlaneRequest
implements ToCopyableBuilder<Builder, PublishRequest> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topic").getter(PublishRequest.getter(PublishRequest::topic)).setter(PublishRequest.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("topic").build()}).build();
    private static final SdkField<Integer> QOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("qos").getter(PublishRequest.getter(PublishRequest::qos)).setter(PublishRequest.setter(Builder::qos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qos").build()}).build();
    private static final SdkField<Boolean> RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("retain").getter(PublishRequest.getter(PublishRequest::retain)).setter(PublishRequest.setter(Builder::retain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("retain").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("payload").getter(PublishRequest.getter(PublishRequest::payload)).setter(PublishRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> USER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userProperties").getter(PublishRequest.getter(PublishRequest::userProperties)).setter(PublishRequest.setter(Builder::userProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-mqtt5-user-properties").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> PAYLOAD_FORMAT_INDICATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payloadFormatIndicator").getter(PublishRequest.getter(PublishRequest::payloadFormatIndicatorAsString)).setter(PublishRequest.setter(Builder::payloadFormatIndicator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-mqtt5-payload-format-indicator").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(PublishRequest.getter(PublishRequest::contentType)).setter(PublishRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("contentType").build()}).build();
    private static final SdkField<String> RESPONSE_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseTopic").getter(PublishRequest.getter(PublishRequest::responseTopic)).setter(PublishRequest.setter(Builder::responseTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("responseTopic").build()}).build();
    private static final SdkField<String> CORRELATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("correlationData").getter(PublishRequest.getter(PublishRequest::correlationData)).setter(PublishRequest.setter(Builder::correlationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-mqtt5-correlation-data").build()}).build();
    private static final SdkField<Long> MESSAGE_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("messageExpiry").getter(PublishRequest.getter(PublishRequest::messageExpiry)).setter(PublishRequest.setter(Builder::messageExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("messageExpiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, QOS_FIELD, RETAIN_FIELD, PAYLOAD_FIELD, USER_PROPERTIES_FIELD, PAYLOAD_FORMAT_INDICATOR_FIELD, CONTENT_TYPE_FIELD, RESPONSE_TOPIC_FIELD, CORRELATION_DATA_FIELD, MESSAGE_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PublishRequest.memberNameToFieldInitializer();
    private final String topic;
    private final Integer qos;
    private final Boolean retain;
    private final SdkBytes payload;
    private final String userProperties;
    private final String payloadFormatIndicator;
    private final String contentType;
    private final String responseTopic;
    private final String correlationData;
    private final Long messageExpiry;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.retain = builder.retain;
        this.payload = builder.payload;
        this.userProperties = builder.userProperties;
        this.payloadFormatIndicator = builder.payloadFormatIndicator;
        this.contentType = builder.contentType;
        this.responseTopic = builder.responseTopic;
        this.correlationData = builder.correlationData;
        this.messageExpiry = builder.messageExpiry;
    }

    public final String topic() {
        return this.topic;
    }

    public final Integer qos() {
        return this.qos;
    }

    public final Boolean retain() {
        return this.retain;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    public final String userProperties() {
        return this.userProperties;
    }

    public final PayloadFormatIndicator payloadFormatIndicator() {
        return PayloadFormatIndicator.fromValue(this.payloadFormatIndicator);
    }

    public final String payloadFormatIndicatorAsString() {
        return this.payloadFormatIndicator;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String responseTopic() {
        return this.responseTopic;
    }

    public final String correlationData() {
        return this.correlationData;
    }

    public final Long messageExpiry() {
        return this.messageExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.qos());
        hashCode = 31 * hashCode + Objects.hashCode(this.retain());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadFormatIndicatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.correlationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)((Object)obj);
        return Objects.equals(this.topic(), other.topic()) && Objects.equals(this.qos(), other.qos()) && Objects.equals(this.retain(), other.retain()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.userProperties(), other.userProperties()) && Objects.equals(this.payloadFormatIndicatorAsString(), other.payloadFormatIndicatorAsString()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.responseTopic(), other.responseTopic()) && Objects.equals(this.correlationData(), other.correlationData()) && Objects.equals(this.messageExpiry(), other.messageExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"PublishRequest").add("Topic", (Object)this.topic()).add("Qos", (Object)this.qos()).add("Retain", (Object)this.retain()).add("Payload", (Object)this.payload()).add("UserProperties", (Object)this.userProperties()).add("PayloadFormatIndicator", (Object)this.payloadFormatIndicatorAsString()).add("ContentType", (Object)this.contentType()).add("ResponseTopic", (Object)this.responseTopic()).add("CorrelationData", (Object)this.correlationData()).add("MessageExpiry", (Object)this.messageExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "qos": {
                return Optional.ofNullable(clazz.cast(this.qos()));
            }
            case "retain": {
                return Optional.ofNullable(clazz.cast(this.retain()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "userProperties": {
                return Optional.ofNullable(clazz.cast(this.userProperties()));
            }
            case "payloadFormatIndicator": {
                return Optional.ofNullable(clazz.cast(this.payloadFormatIndicatorAsString()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "responseTopic": {
                return Optional.ofNullable(clazz.cast(this.responseTopic()));
            }
            case "correlationData": {
                return Optional.ofNullable(clazz.cast(this.correlationData()));
            }
            case "messageExpiry": {
                return Optional.ofNullable(clazz.cast(this.messageExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("topic", TOPIC_FIELD);
        map.put("qos", QOS_FIELD);
        map.put("retain", RETAIN_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("x-amz-mqtt5-user-properties", USER_PROPERTIES_FIELD);
        map.put("x-amz-mqtt5-payload-format-indicator", PAYLOAD_FORMAT_INDICATOR_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("responseTopic", RESPONSE_TOPIC_FIELD);
        map.put("x-amz-mqtt5-correlation-data", CORRELATION_DATA_FIELD);
        map.put("messageExpiry", MESSAGE_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublishRequest, T> g) {
        return obj -> g.apply((PublishRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDataPlaneRequest.BuilderImpl
    implements Builder {
        private String topic;
        private Integer qos;
        private Boolean retain;
        private SdkBytes payload;
        private String userProperties;
        private String payloadFormatIndicator;
        private String contentType;
        private String responseTopic;
        private String correlationData;
        private Long messageExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            super(model);
            this.topic(model.topic);
            this.qos(model.qos);
            this.retain(model.retain);
            this.payload(model.payload);
            this.userProperties(model.userProperties);
            this.payloadFormatIndicator(model.payloadFormatIndicator);
            this.contentType(model.contentType);
            this.responseTopic(model.responseTopic);
            this.correlationData(model.correlationData);
            this.messageExpiry(model.messageExpiry);
        }

        public final String getTopic() {
            return this.topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final Integer getQos() {
            return this.qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final Boolean getRetain() {
            return this.retain;
        }

        public final void setRetain(Boolean retain) {
            this.retain = retain;
        }

        @Override
        public final Builder retain(Boolean retain) {
            this.retain = retain;
            return this;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getUserProperties() {
            return this.userProperties;
        }

        public final void setUserProperties(String userProperties) {
            this.userProperties = userProperties;
        }

        @Override
        public final Builder userProperties(String userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public final String getPayloadFormatIndicator() {
            return this.payloadFormatIndicator;
        }

        public final void setPayloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
        }

        @Override
        public final Builder payloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
            return this;
        }

        @Override
        public final Builder payloadFormatIndicator(PayloadFormatIndicator payloadFormatIndicator) {
            this.payloadFormatIndicator(payloadFormatIndicator == null ? null : payloadFormatIndicator.toString());
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getResponseTopic() {
            return this.responseTopic;
        }

        public final void setResponseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
        }

        @Override
        public final Builder responseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
            return this;
        }

        public final String getCorrelationData() {
            return this.correlationData;
        }

        public final void setCorrelationData(String correlationData) {
            this.correlationData = correlationData;
        }

        @Override
        public final Builder correlationData(String correlationData) {
            this.correlationData = correlationData;
            return this;
        }

        public final Long getMessageExpiry() {
            return this.messageExpiry;
        }

        public final void setMessageExpiry(Long messageExpiry) {
            this.messageExpiry = messageExpiry;
        }

        @Override
        public final Builder messageExpiry(Long messageExpiry) {
            this.messageExpiry = messageExpiry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotDataPlaneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishRequest> {
        public Builder topic(String var1);

        public Builder qos(Integer var1);

        public Builder retain(Boolean var1);

        public Builder payload(SdkBytes var1);

        public Builder userProperties(String var1);

        public Builder payloadFormatIndicator(String var1);

        public Builder payloadFormatIndicator(PayloadFormatIndicator var1);

        public Builder contentType(String var1);

        public Builder responseTopic(String var1);

        public Builder correlationData(String var1);

        public Builder messageExpiry(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

