/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PayloadFormatIndicator {
    UNSPECIFIED_BYTES("UNSPECIFIED_BYTES"),
    UTF8_DATA("UTF8_DATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PayloadFormatIndicator> VALUE_MAP;
    private final String value;

    private PayloadFormatIndicator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PayloadFormatIndicator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PayloadFormatIndicator> knownValues() {
        EnumSet<PayloadFormatIndicator> knownValues = EnumSet.allOf(PayloadFormatIndicator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PayloadFormatIndicator.class, PayloadFormatIndicator::toString);
    }
}

