/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about one or more alarm actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmEventActions implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmEventActions.Builder, AlarmEventActions> {
    private static final SdkField<List<AlarmAction>> ALARM_ACTIONS_FIELD = SdkField
            .<List<AlarmAction>> builder(MarshallingType.LIST)
            .memberName("alarmActions")
            .getter(getter(AlarmEventActions::alarmActions))
            .setter(setter(Builder::alarmActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlarmAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlarmAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AlarmAction> alarmActions;

    private AlarmEventActions(BuilderImpl builder) {
        this.alarmActions = builder.alarmActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlarmActions() {
        return alarmActions != null && !(alarmActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more supported actions to receive notifications when the alarm state changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmActions} method.
     * </p>
     * 
     * @return Specifies one or more supported actions to receive notifications when the alarm state changes.
     */
    public final List<AlarmAction> alarmActions() {
        return alarmActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmActions() ? alarmActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmEventActions)) {
            return false;
        }
        AlarmEventActions other = (AlarmEventActions) obj;
        return hasAlarmActions() == other.hasAlarmActions() && Objects.equals(alarmActions(), other.alarmActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmEventActions").add("AlarmActions", hasAlarmActions() ? alarmActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmActions":
            return Optional.ofNullable(clazz.cast(alarmActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmEventActions, T> g) {
        return obj -> g.apply((AlarmEventActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmEventActions> {
        /**
         * <p>
         * Specifies one or more supported actions to receive notifications when the alarm state changes.
         * </p>
         * 
         * @param alarmActions
         *        Specifies one or more supported actions to receive notifications when the alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(Collection<AlarmAction> alarmActions);

        /**
         * <p>
         * Specifies one or more supported actions to receive notifications when the alarm state changes.
         * </p>
         * 
         * @param alarmActions
         *        Specifies one or more supported actions to receive notifications when the alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(AlarmAction... alarmActions);

        /**
         * <p>
         * Specifies one or more supported actions to receive notifications when the alarm state changes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AlarmAction>.Builder} avoiding the need to
         * create one manually via {@link List<AlarmAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AlarmAction>.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmActions(List<AlarmAction>)}.
         * 
         * @param alarmActions
         *        a consumer that will call methods on {@link List<AlarmAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmActions(List<AlarmAction>)
         */
        Builder alarmActions(Consumer<AlarmAction.Builder>... alarmActions);
    }

    static final class BuilderImpl implements Builder {
        private List<AlarmAction> alarmActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmEventActions model) {
            alarmActions(model.alarmActions);
        }

        public final List<AlarmAction.Builder> getAlarmActions() {
            List<AlarmAction.Builder> result = AlarmActionsCopier.copyToBuilder(this.alarmActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmActions(Collection<AlarmAction.BuilderImpl> alarmActions) {
            this.alarmActions = AlarmActionsCopier.copyFromBuilder(alarmActions);
        }

        @Override
        @Transient
        public final Builder alarmActions(Collection<AlarmAction> alarmActions) {
            this.alarmActions = AlarmActionsCopier.copy(alarmActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alarmActions(AlarmAction... alarmActions) {
            alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alarmActions(Consumer<AlarmAction.Builder>... alarmActions) {
            alarmActions(Stream.of(alarmActions).map(c -> AlarmAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AlarmEventActions build() {
            return new AlarmEventActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
